/*
 * Decompiled with CFR 0.152.
 */
package rx.redis.japi;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import rx.Observable;
import rx.functions.Func1;
import rx.redis.client.RawClient;
import rx.redis.japi.DefaultBytes;
import rx.redis.resp.DataType;
import rx.redis.resp.RespType;
import rx.redis.serialization.BytesFormat;
import rx.redis.serialization.Writes;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;

public final class Client {
    private final RawClient raw;
    private static final Func1<Object, Boolean> toJBool = object -> (Boolean)object;
    private static final Func1<Object, Long> toJLong = object -> (Long)object;

    public Client(RawClient rawClient) {
        this.raw = rawClient;
    }

    public static <T, U> Tuple2<T, U> pair(T t, U u) {
        return Tuple2.apply(t, u);
    }

    public Observable<Void> shutdown() {
        return this.raw.shutdown().map(boxedUnit -> null);
    }

    public Observable<Void> closedObservable() {
        return this.raw.closedObservable().map(boxedUnit -> null);
    }

    public Observable<RespType> command(DataType dataType) {
        return this.raw.command(dataType);
    }

    public <A> Observable<RespType> command(A a, Writes<A> writes) {
        return this.raw.command(a, writes);
    }

    public Observable<Long> del(String ... stringArray) {
        return this.raw.del(Client.tsToSeq(stringArray)).map(toJLong);
    }

    public Observable<Boolean> exists(String string) {
        return this.raw.exists(string).map(toJBool);
    }

    public Observable<Boolean> expire(String string, FiniteDuration finiteDuration) {
        return this.raw.expire(string, finiteDuration).map(toJBool);
    }

    public Observable<Boolean> expireAt(String string, Deadline deadline) {
        return this.raw.expireAt(string, deadline).map(toJBool);
    }

    public Observable<String> keys(String string) {
        return this.raw.keys(string);
    }

    public Observable<Optional<String>> randomKey() {
        return this.raw.randomKey().map(Client.optionFunc());
    }

    public Observable<Long> ttl(String string) {
        return this.raw.ttl(string).map(toJLong);
    }

    public <T> Observable<Optional<T>> getAs(String string, BytesFormat<T> bytesFormat) {
        return this.raw.get(string, bytesFormat).map(Client.optionFunc());
    }

    public Observable<Optional<String>> get(String string) {
        return this.getAs(string, DefaultBytes.STRING_BYTES_FORMAT);
    }

    public Observable<Optional<byte[]>> getBytes(String string) {
        return this.getAs(string, DefaultBytes.BYTES_BYTES_FORMAT);
    }

    public <T> Observable<Boolean> setAs(String string, T t, BytesFormat<T> bytesFormat) {
        return this.raw.set(string, t, bytesFormat).map(toJBool);
    }

    public Observable<Boolean> set(String string, String string2) {
        return this.setAs(string, string2, DefaultBytes.STRING_BYTES_FORMAT);
    }

    public Observable<Boolean> set(String string, byte[] byArray) {
        return this.setAs(string, byArray, DefaultBytes.BYTES_BYTES_FORMAT);
    }

    public <T> Observable<Boolean> setEx(String string, T t, FiniteDuration finiteDuration, BytesFormat<T> bytesFormat) {
        return this.raw.setEx(string, t, finiteDuration, bytesFormat).map(toJBool);
    }

    public <T> Observable<Boolean> setNx(String string, T t, BytesFormat<T> bytesFormat) {
        return this.raw.setNx(string, t, bytesFormat).map(toJBool);
    }

    public Observable<Long> incr(String string) {
        return this.raw.incr(string).map(toJLong);
    }

    public Observable<Long> incrBy(String string, long l) {
        return this.raw.incrBy(string, l).map(toJLong);
    }

    public Observable<Long> decr(String string) {
        return this.raw.decr(string).map(toJLong);
    }

    public Observable<Long> decrBy(String string, long l) {
        return this.raw.decrBy(string, l).map(toJLong);
    }

    public <T> Observable<Optional<T>> mgetAs(BytesFormat<T> bytesFormat, String ... stringArray) {
        return this.raw.mget(Client.tsToSeq(stringArray), bytesFormat).map(Client.optionFunc());
    }

    public Observable<Optional<String>> mget(String ... stringArray) {
        return this.mgetAs(DefaultBytes.STRING_BYTES_FORMAT, stringArray);
    }

    public Observable<Optional<byte[]>> mgetBytes(String ... stringArray) {
        return this.mgetAs(DefaultBytes.BYTES_BYTES_FORMAT, stringArray);
    }

    @SafeVarargs
    public final <T> Observable<Boolean> msetAs(BytesFormat<T> bytesFormat, Map.Entry<String, T> ... entryArray) {
        return this.raw.mset(Client.tsMapToSeq(entry -> Tuple2.apply(entry.getKey(), entry.getValue()), entryArray), bytesFormat).map(toJBool);
    }

    @SafeVarargs
    public final <T> Observable<Boolean> msetAs(BytesFormat<T> bytesFormat, Tuple2<String, T> ... tuple2Array) {
        return this.raw.mset(Client.tsToSeq(tuple2Array), bytesFormat).map(toJBool);
    }

    public final <T> Observable<Boolean> msetAs(BytesFormat<T> bytesFormat, Map<String, T> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().toArray();
        return this.msetAs(bytesFormat, entryArray);
    }

    @SafeVarargs
    public final Observable<Boolean> mset(Map.Entry<String, String> ... entryArray) {
        return this.msetAs(DefaultBytes.STRING_BYTES_FORMAT, entryArray);
    }

    @SafeVarargs
    public final Observable<Boolean> mset(Tuple2<String, String> ... tuple2Array) {
        return this.msetAs(DefaultBytes.STRING_BYTES_FORMAT, tuple2Array);
    }

    public final Observable<Boolean> mset(Map<String, String> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().toArray();
        return this.msetAs(DefaultBytes.STRING_BYTES_FORMAT, entryArray);
    }

    @SafeVarargs
    public final Observable<Boolean> msetBytes(Map.Entry<String, byte[]> ... entryArray) {
        return this.msetAs(DefaultBytes.BYTES_BYTES_FORMAT, entryArray);
    }

    @SafeVarargs
    public final Observable<Boolean> msetBytes(Tuple2<String, byte[]> ... tuple2Array) {
        return this.msetAs(DefaultBytes.BYTES_BYTES_FORMAT, tuple2Array);
    }

    public final Observable<Boolean> msetBytes(Map<String, byte[]> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().toArray();
        return this.msetAs(DefaultBytes.BYTES_BYTES_FORMAT, entryArray);
    }

    public Observable<Long> strLen(String string) {
        return this.raw.strLen(string).map(toJLong);
    }

    public <A> Observable<Optional<A>> hgetAs(String string, String string2, BytesFormat<A> bytesFormat) {
        return this.raw.hget(string, string2, bytesFormat).map(Client.optionFunc());
    }

    public Observable<Optional<String>> hget(String string, String string2) {
        return this.hgetAs(string, string2, DefaultBytes.STRING_BYTES_FORMAT);
    }

    public Observable<Optional<byte[]>> hgetBytes(String string, String string2) {
        return this.hgetAs(string, string2, DefaultBytes.BYTES_BYTES_FORMAT);
    }

    public <A> Observable<Tuple2<String, A>> hgetAllAs(String string, BytesFormat<A> bytesFormat) {
        return this.raw.hgetAll(string, bytesFormat);
    }

    public Observable<Map.Entry<String, String>> hgetAll(String string) {
        return this.raw.hgetAll(string, DefaultBytes.STRING_BYTES_FORMAT).map(Client.entryFunc());
    }

    public Observable<Map.Entry<String, byte[]>> hgetAllBytes(String string) {
        return this.raw.hgetAll(string, DefaultBytes.BYTES_BYTES_FORMAT).map(Client.entryFunc());
    }

    public Observable<String> ping() {
        return this.raw.ping();
    }

    public <T> Observable<T> echo(T t, BytesFormat<T> bytesFormat) {
        return this.raw.echo(t, bytesFormat);
    }

    public Observable<String> echo(String string) {
        return this.echo(string, DefaultBytes.STRING_BYTES_FORMAT);
    }

    public Observable<byte[]> echo(byte[] byArray) {
        return this.echo(byArray, DefaultBytes.BYTES_BYTES_FORMAT);
    }

    @SafeVarargs
    private static <T> Seq<T> tsToSeq(T ... TArray) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(Stream.of(TArray).iterator()).asScala()).toVector();
    }

    @SafeVarargs
    private static <T, R> Seq<R> tsMapToSeq(Function<? super T, ? extends R> function, T ... TArray) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(Stream.of(TArray).map(function).iterator()).asScala()).toVector();
    }

    private static <T> Func1<Option<T>, Optional<T>> optionFunc() {
        return option -> {
            if (option.isDefined()) {
                return Optional.of(option.get());
            }
            return Optional.empty();
        };
    }

    private static <T, U> Func1<Tuple2<T, U>, Map.Entry<T, U>> entryFunc() {
        return tuple2 -> new AbstractMap.SimpleImmutableEntry<Object, Object>(tuple2._1(), tuple2._2());
    }
}

