/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.shared.util;

import de.knightsoftnet.validators.shared.data.CountryEnum;
import de.knightsoftnet.validators.shared.data.PhoneNumberData;
import de.knightsoftnet.validators.shared.data.PhoneNumberInterface;
import de.knightsoftnet.validators.shared.data.ValueWithPos;
import de.knightsoftnet.validators.shared.testcases.PhoneNumberUtilTestCases;
import de.knightsoftnet.validators.shared.util.PhoneNumberUtil;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhoneNumberUtilTest {
    private PhoneNumberUtil phoneNumberUtil;

    @Before
    public void setUp() {
        this.phoneNumberUtil = new PhoneNumberUtil("DE");
    }

    @Test
    public void testParsing() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.parsePhoneNumber((String)null));
        for (Map.Entry<String, PhoneNumberInterface> testCase : PhoneNumberUtilTestCases.getParseCases().entrySet()) {
            PhoneNumberData parsedNumber = this.phoneNumberUtil.parsePhoneNumber(testCase.getKey());
            Assert.assertEquals((String)("Parsing " + testCase.getKey()), (Object)testCase.getValue(), (Object)parsedNumber);
        }
    }

    @Test
    public void testFormatE123() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatE123Cases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatE123(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatE123WithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatE123WithPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatE123(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatE123International() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123International((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatE123InternationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatE123International(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 international " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatE123InternationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123International((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatE123InternationalpCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatE123International(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 international " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatE123National() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123National((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatE123NationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatE123National(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 national " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatE123NationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatE123National((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatE123NationalPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatE123National(testCase.getKey());
            Assert.assertEquals((String)("Formating E123 national " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatDin5008Cases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatDin5008(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008WithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatDin5008WithPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatDin5008(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008International() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008International((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatDin5008InternationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatDin5008International(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 international " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008InternationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008International((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatDin5008InternPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatDin5008International(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 international " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008National() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008National((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatDin5008NationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatDin5008National(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 national " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatDin5008NationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatDin5008National((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatDin5008NationalPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatDin5008National(testCase.getKey());
            Assert.assertEquals((String)("Formating DIN 5008 national " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatRfc3966() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatRfc3966((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatRfc3966Cases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatRfc3966(testCase.getKey());
            Assert.assertEquals((String)("Formating RFC 3966 " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatRfc3966WithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatRfc3966((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatRfc3966WithPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatRfc3966(testCase.getKey());
            Assert.assertEquals((String)("Formating Rfc3966 " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatMs() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatMs((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatMsCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatMs(testCase.getKey());
            Assert.assertEquals((String)("Formating MS " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatMsWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatMs((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatMsWithLengthCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatMs(testCase.getKey());
            Assert.assertEquals((String)("Formating MS " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatUrl() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatUrl((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatUrlCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatUrl(testCase.getKey());
            Assert.assertEquals((String)("Formating URL " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatUrlWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatUrl((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatUrlWithPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatUrl(testCase.getKey());
            Assert.assertEquals((String)("Formating Url " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommon() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommon((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatCommonCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatCommon(testCase.getKey());
            Assert.assertEquals((String)("Formating common " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommonWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommon((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatCommonWithPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatCommon(testCase.getKey());
            Assert.assertEquals((String)("Formating Common " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommonInternational() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommonInternational((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatCommonInternationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatCommonInternational(testCase.getKey());
            Assert.assertEquals((String)("Formating common international " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommonInternationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommonInternational((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatCommonInterPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatCommonInternational(testCase.getKey());
            Assert.assertEquals((String)("Formating Common international " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommonNational() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommonNational((PhoneNumberInterface)((PhoneNumberData)null)));
        for (Map.Entry<PhoneNumberInterface, String> testCase : PhoneNumberUtilTestCases.getFormatCommonNationalCases().entrySet()) {
            String formatedNumber = this.phoneNumberUtil.formatCommonNational(testCase.getKey());
            Assert.assertEquals((String)("Formating common national " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testFormatCommonNationalWithPos() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.formatCommonNational((ValueWithPos)null));
        for (Map.Entry<ValueWithPos<String>, ValueWithPos<String>> testCase : PhoneNumberUtilTestCases.getFormatCommonNationalPosCases().entrySet()) {
            ValueWithPos formatedNumber = this.phoneNumberUtil.formatCommonNational(testCase.getKey());
            Assert.assertEquals((String)("Formating Common national " + testCase.getKey().toString()), testCase.getValue(), (Object)formatedNumber);
        }
    }

    @Test
    public void testDetectCountryCode() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.detectCountryCode((PhoneNumberInterface)null));
        for (Map.Entry<PhoneNumberInterface, CountryEnum> testCase : PhoneNumberUtilTestCases.detectCountryCodeCases().entrySet()) {
            CountryEnum coutryCode = this.phoneNumberUtil.detectCountryCode(testCase.getKey());
            Assert.assertEquals((String)("Detecting country code " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)coutryCode);
        }
    }

    @Test
    public void testDetectCountryCodeWithParsing() {
        Assert.assertNull((String)"Should be null", (Object)this.phoneNumberUtil.detectCountryCode((String)null));
        for (Map.Entry<String, CountryEnum> testCase : PhoneNumberUtilTestCases.detectCountryCodeCasesWithParsing().entrySet()) {
            CountryEnum coutryCode = this.phoneNumberUtil.detectCountryCode(testCase.getKey());
            Assert.assertEquals((String)("Detecting country code " + testCase.getKey().toString()), (Object)testCase.getValue(), (Object)coutryCode);
        }
    }
}

