/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.shared.testcases;

import de.knightsoftnet.validators.shared.data.CountryEnum;
import de.knightsoftnet.validators.shared.data.PhoneNumberData;
import de.knightsoftnet.validators.shared.data.PhoneNumberInterface;
import de.knightsoftnet.validators.shared.data.ValueWithPos;
import java.util.HashMap;
import java.util.Map;

public class PhoneNumberUtilTestCases {
    public static final Map<String, PhoneNumberInterface> getParseCases() {
        HashMap<String, PhoneNumberInterface> testData = new HashMap<String, PhoneNumberInterface>();
        testData.put("+3162912345", (PhoneNumberInterface)new PhoneNumberData("31", "629", "12345", null));
        testData.put("+49891234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("+49-89-1234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("+49 89 1234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("+49 89 12 34 - 56 78", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("+49 (89) 1234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("+49 (0)89 1234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("089 1234-5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("(089) 1234 5678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"));
        testData.put("0 89 / 12 34 56 78", (PhoneNumberInterface)new PhoneNumberData("49", "89", "123456", "78"));
        testData.put("+49 (89) 12345678", (PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null));
        testData.put("+491512312345678", (PhoneNumberInterface)new PhoneNumberData("49", "1512", "312345678", null));
        testData.put("+491582312345678", (PhoneNumberInterface)new PhoneNumberData("49", "15823", "12345678", null));
        testData.put("+390612345678", (PhoneNumberInterface)new PhoneNumberData("39", "06", "12345678", null));
        testData.put("00390612345678", (PhoneNumberInterface)new PhoneNumberData("39", "06", "12345678", null));
        testData.put("+41 26 324 11 13", (PhoneNumberInterface)new PhoneNumberData("41", "26", "32411", "13"));
        testData.put("+1216123456", (PhoneNumberInterface)new PhoneNumberData("1", "216", "123456", null));
        testData.put("+222123456", (PhoneNumberInterface)new PhoneNumberData("222", null, "123456", null));
        testData.put("+22263123456", (PhoneNumberInterface)new PhoneNumberData("222", "63", "123456", null));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatE123Cases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "(089) 1234 5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "(089) 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 662 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatE123WithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 3));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 16));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatE123InternationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49 89 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49 89 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 662 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatE123InternationalpCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 12345678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 12345678", 16));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatE123NationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "(089) 1234 5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "(089) 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "(0662) 1234 5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "(0662) 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatE123NationalPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 3));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"(089) 1234 5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 3));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"(0662) 1234 5678", 16));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatDin5008Cases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "089 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "089 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 662 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatDin5008WithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 17));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatDin5008InternationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49 89 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49 89 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 662 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatDin5008InternPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 89 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 662 1234-5678", 17));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatDin5008NationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "089 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "089 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "0662 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "0662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatDin5008NationalPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"089 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 3));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0662 1234-5678", 14));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatRfc3966Cases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49-89-12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49-89-12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43-662-12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43-662-12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatRfc3966WithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-12345678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-12345678", 16));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatMsCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49 (89) 1234 - 5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49 (89) 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 (662) 1234 - 5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 (662) 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatMsWithLengthCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 6));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 17));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 18));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 19));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 20));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (89) 1234 - 5678", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 18));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 19));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 21));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (662) 1234 - 5678", 21));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatUrlCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49-89-1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49-89-12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43-662-1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43-662-12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatUrlWithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 4));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 5));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 9));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 14));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49-89-1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 4));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 6));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 15));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43-662-1234-5678", 17));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatCommonCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "0 89 / 12 34 - 56 78");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "0 89 / 12 34 56 78");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 (0)662 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 (0)662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatCommonWithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 3));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 18));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 19));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 20));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 18));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 19));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 20));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatCommonInternationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "+49 (0)89 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "+49 (0)89 12345678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "+43 (0)662 1234-5678");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "+43 (0)662 12345678");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatCommonInterPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 17));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 18));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 19));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"+49 (0)89 1234-5678", 19));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 1));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 7));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 8));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 11));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 14));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 16));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 18));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 19));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"+43 (0)662 1234-5678", 20));
        return testData;
    }

    public static final Map<PhoneNumberInterface, String> getFormatCommonNationalCases() {
        HashMap<PhoneNumberInterface, String> testData = new HashMap<PhoneNumberInterface, String>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), "0 89 / 12 34 - 56 78");
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "12345678", null), "0 89 / 12 34 56 78");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), "0 66 2 / 12 34 - 56 78");
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "12345678", null), "0 66 2 / 12 34 56 78");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getFormatCommonNationalPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"089/1234-5678", 0), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 1), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 2));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 2), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 3));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 3), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 4), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 7));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 5), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 8));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 6), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 10));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 7), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 11));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 8), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 9), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 15));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 10), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 16));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 11), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 18));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 12), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 19));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 13), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 20));
        testData.put(new ValueWithPos((Object)"089/1234-5678", 14), new ValueWithPos((Object)"089/1234-5678", (Object)"0 89 / 12 34 - 56 78", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 0), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 1), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 2), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 3), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 0));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 4), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 2));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 5), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 3));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 6), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 5));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 7), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 8), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 9));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 9), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 10));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 10), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 12));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 11), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 13));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 12), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 13), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 17));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 14), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 18));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 15), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 20));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 16), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 21));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 17), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 22));
        testData.put(new ValueWithPos((Object)"0043662/1234-5678", 18), new ValueWithPos((Object)"0043662/1234-5678", (Object)"0 66 2 / 12 34 - 56 78", 22));
        return testData;
    }

    public static final Map<PhoneNumberInterface, CountryEnum> detectCountryCodeCases() {
        HashMap<PhoneNumberInterface, CountryEnum> testData = new HashMap<PhoneNumberInterface, CountryEnum>();
        testData.put((PhoneNumberInterface)new PhoneNumberData("49", "89", "1234", "5678"), CountryEnum.DE);
        testData.put((PhoneNumberInterface)new PhoneNumberData("43", "662", "1234", "5678"), CountryEnum.AT);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "216", "123456", null), CountryEnum.US);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "250", "123456", null), CountryEnum.CA);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "242", "123456", null), CountryEnum.BS);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "246", "123456", null), CountryEnum.BB);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "264", "123456", null), CountryEnum.AI);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "268", "123456", null), CountryEnum.AG);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "284", "123456", null), CountryEnum.VG);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "340", "123456", null), CountryEnum.VI);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "345", "123456", null), CountryEnum.KY);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "441", "123456", null), CountryEnum.BM);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "473", "123456", null), CountryEnum.GD);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "649", "123456", null), CountryEnum.TC);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "664", "123456", null), CountryEnum.MS);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "670", "123456", null), CountryEnum.MP);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "671", "123456", null), CountryEnum.GU);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "684", "123456", null), CountryEnum.AS);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "721", "123456", null), CountryEnum.SX);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "758", "123456", null), CountryEnum.LC);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "767", "123456", null), CountryEnum.DM);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "784", "123456", null), CountryEnum.VC);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "787", "123456", null), CountryEnum.PR);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "939", "123456", null), CountryEnum.PR);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "809", "123456", null), CountryEnum.DO);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "829", "123456", null), CountryEnum.DO);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "849", "123456", null), CountryEnum.DO);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "868", "123456", null), CountryEnum.TT);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "869", "123456", null), CountryEnum.KN);
        testData.put((PhoneNumberInterface)new PhoneNumberData("1", "876", "123456", null), CountryEnum.JM);
        testData.put((PhoneNumberInterface)new PhoneNumberData("599", "7", "123456", null), CountryEnum.BQ);
        testData.put((PhoneNumberInterface)new PhoneNumberData("599", "9", "123456", null), CountryEnum.CW);
        testData.put((PhoneNumberInterface)new PhoneNumberData("7", "600", "123456", null), CountryEnum.KZ);
        testData.put((PhoneNumberInterface)new PhoneNumberData("7", "7213", "123456", null), CountryEnum.KZ);
        testData.put((PhoneNumberInterface)new PhoneNumberData("7", "499", "123456", null), CountryEnum.RU);
        testData.put((PhoneNumberInterface)new PhoneNumberData("222", "63", "123456", null), CountryEnum.MR);
        return testData;
    }

    public static final Map<String, CountryEnum> detectCountryCodeCasesWithParsing() {
        HashMap<String, CountryEnum> testData = new HashMap<String, CountryEnum>();
        testData.put("0 89 / 12 34 56 78", CountryEnum.DE);
        testData.put("+43 (0)662 1234-5678", CountryEnum.AT);
        return testData;
    }
}

