/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.shared.testcases;

import de.knightsoftnet.validators.shared.data.ValueWithPos;
import java.util.HashMap;
import java.util.Map;

public class IsbnUtilTestCases {
    public static final Map<String, String> getIsbn10FormatCases() {
        HashMap<String, String> testData = new HashMap<String, String>();
        testData.put("3-80-770171-0", "3807701710");
        testData.put("3-80-770205-9", "3807702059");
        testData.put("3-80-770192-3", "3807701923");
        testData.put("3-86-640001-2", "3866400012");
        testData.put("3-80-770171-0", "3807701710");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getIsbn10FormatWithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 0), new ValueWithPos((Object)"3807701710", -1));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 0), new ValueWithPos((Object)"3807701710", 0));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 2), new ValueWithPos((Object)"3807701710", 1));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 3), new ValueWithPos((Object)"3807701710", 2));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 5), new ValueWithPos((Object)"3807701710", 3));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 6), new ValueWithPos((Object)"3807701710", 4));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 7), new ValueWithPos((Object)"3807701710", 5));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 8), new ValueWithPos((Object)"3807701710", 6));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 9), new ValueWithPos((Object)"3807701710", 7));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 10), new ValueWithPos((Object)"3807701710", 8));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 12), new ValueWithPos((Object)"3807701710", 9));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 13), new ValueWithPos((Object)"3807701710", 10));
        testData.put(new ValueWithPos((Object)"3807701710", (Object)"3-80-770171-0", 13), new ValueWithPos((Object)"3807701710", 11));
        return testData;
    }

    public static final Map<String, String> getIsbn13FormatCases() {
        HashMap<String, String> testData = new HashMap<String, String>();
        testData.put("978-3-83-621802-3", "9783836218023");
        testData.put("978-3-83-621507-7", "9783836215077");
        testData.put("978-3-89-864471-6", "9783898644716");
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getIsbn13FormatWithPosCases() {
        HashMap<ValueWithPos<String>, ValueWithPos<String>> testData = new HashMap<ValueWithPos<String>, ValueWithPos<String>>();
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 0), new ValueWithPos((Object)"9783836218023", -1));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 0), new ValueWithPos((Object)"9783836218023", 0));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 1), new ValueWithPos((Object)"9783836218023", 1));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 2), new ValueWithPos((Object)"9783836218023", 2));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 4), new ValueWithPos((Object)"9783836218023", 3));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 6), new ValueWithPos((Object)"9783836218023", 4));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 7), new ValueWithPos((Object)"9783836218023", 5));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 9), new ValueWithPos((Object)"9783836218023", 6));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 10), new ValueWithPos((Object)"9783836218023", 7));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 11), new ValueWithPos((Object)"9783836218023", 8));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 12), new ValueWithPos((Object)"9783836218023", 9));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 13), new ValueWithPos((Object)"9783836218023", 10));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 14), new ValueWithPos((Object)"9783836218023", 11));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 16), new ValueWithPos((Object)"9783836218023", 12));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 17), new ValueWithPos((Object)"9783836218023", 13));
        testData.put(new ValueWithPos((Object)"9783836218023", (Object)"978-3-83-621802-3", 17), new ValueWithPos((Object)"9783836218023", 14));
        return testData;
    }

    public static final Map<String, String> getIsbnFormatCases() {
        Map<String, String> testData = IsbnUtilTestCases.getIsbn10FormatCases();
        testData.putAll(IsbnUtilTestCases.getIsbn13FormatCases());
        return testData;
    }

    public static Map<ValueWithPos<String>, ValueWithPos<String>> getIsbnFormatWithPosCases() {
        Map<ValueWithPos<String>, ValueWithPos<String>> testData = IsbnUtilTestCases.getIsbn10FormatWithPosCases();
        testData.putAll(IsbnUtilTestCases.getIsbn13FormatWithPosCases());
        return testData;
    }

    public static final Map<String, String> getCompressCases() {
        HashMap<String, String> testData = new HashMap<String, String>();
        testData.put("3807701710", "3-80-770171-0");
        testData.put("3807702059", "3-80-770205-9");
        testData.put("3807701923", "3-80-770192-3");
        testData.put("3866400012", "3-86-640001-2");
        testData.put("3807701710", "3-80-770171-0");
        testData.put("9783836218023", "978-3-83-621802-3");
        testData.put("9783836215077", "978-3-83-621507-7");
        testData.put("9783898644716", "978-3-89-864471-6");
        return testData;
    }
}

