/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.shared.beans;

import de.knightsoftnet.validators.shared.interfaces.LocalizedValue;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class LocalizedValueTestImpl
implements LocalizedValue<String, String> {
    private final Map<@NotEmpty String, String> localizedText = new HashMap<String, String>();

    public LocalizedValueTestImpl() {
    }

    @SafeVarargs
    public LocalizedValueTestImpl(String[] ... values) {
        Arrays.asList(values).forEach(entry -> this.localizedText.put(entry[0], entry[1]));
    }

    public void setLocalizedText(Map<String, String> localizedText) {
        this.localizedText.clear();
        if (localizedText != null && !localizedText.isEmpty()) {
            this.localizedText.putAll(localizedText);
        }
    }

    public void putLocalizedText(String language, String text) {
        this.localizedText.put(language, text);
    }

    public Map<String, String> getLocalizedText() {
        return this.localizedText;
    }

    public String getLocalizedText(String language) {
        return this.localizedText.get(language);
    }

    public String toString() {
        StringBuilder toStringvalue = new StringBuilder();
        toStringvalue.append("LocalizedValueTestImpl [");
        this.localizedText.forEach((key, value) -> toStringvalue.append("localizedText[").append((String)key).append("]=").append((String)value).append(','));
        toStringvalue.append(']');
        return toStringvalue.toString();
    }
}

