/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.PasswordTestBean;
import de.knightsoftnet.validators.shared.testcases.PasswordTestCases;
import org.junit.Test;

public class PasswordTest
extends AbstractValidationTest<PasswordTestBean> {
    @Test
    public final void testEmptyPasswordIsAllowed() {
        super.validationTest(PasswordTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectPasswordsAreAllowed() {
        for (PasswordTestBean testBean : PasswordTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongPasswordsAreWrong() {
        for (PasswordTestBean testBean : PasswordTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.PasswordValidator");
        }
    }

    @Test
    public final void testBlacklistedPasswordsAreWrong() {
        for (PasswordTestBean testBean : PasswordTestCases.getBlackListedTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.PasswordValidator");
        }
    }

    @Test
    public final void testWrongStartCharAreWrong() {
        for (PasswordTestBean testBean : PasswordTestCases.getWrongStartCharTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.PasswordValidator");
        }
    }

    @Test
    public final void testExceededRepeatAreWrong() {
        for (PasswordTestBean testBean : PasswordTestCases.getExceededRepeatTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.PasswordValidator");
        }
    }
}

