/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.ListOfEmailsTestBean;
import de.knightsoftnet.validators.shared.testcases.ListOfEmailsTestCases;
import jakarta.validation.ConstraintViolation;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ListOfEmailsTest
extends AbstractValidationTest<ListOfEmailsTestBean> {
    @Test
    public final void testEmptyEmailIsNotAllowed() {
        super.validationTest(ListOfEmailsTestCases.getEmptyTestBean(), false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
    }

    @Test
    public final void testCorrectEmailsAreAllowed() {
        for (ListOfEmailsTestBean testBean : ListOfEmailsTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongEmailsAreWrong() {
        for (ListOfEmailsTestBean testBean : ListOfEmailsTestCases.getWrongTestBeans()) {
            Set<ConstraintViolation<ListOfEmailsTestBean>> cv1 = super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.EmailValidator");
            Assert.assertEquals((String)"Path should contain list position", (Object)testBean.getPath(), (Object)cv1.iterator().next().getPropertyPath().toString());
        }
    }
}

