/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.IsbnTestBean;
import de.knightsoftnet.validators.shared.testcases.IsbnTestCases;
import org.junit.Test;

public class IsbnTest
extends AbstractValidationTest<IsbnTestBean> {
    @Test
    public final void testEmptyIsbnIsAllowed() {
        super.validationTest(IsbnTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbnIsAllowed() {
        for (IsbnTestBean testBean : IsbnTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbnIsWrong() {
        for (IsbnTestBean testBean : IsbnTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IsbnValidator");
        }
    }

    @Test
    public final void testWrongSizeIsbnIsWrong() {
        for (IsbnTestBean testBean : IsbnTestCases.getWrongSizeTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }

    @Test
    public final void testNotNumericIsbnIsWrong() {
        for (IsbnTestBean testBean : IsbnTestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IsbnValidator");
        }
    }
}

