/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn13WithSeparatorsTestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn13WithSeparatorsTestCases;
import org.junit.Test;

public class Isbn13WithSeparatorsTest
extends AbstractValidationTest<Isbn13WithSeparatorsTestBean> {
    @Test
    public final void testEmptyIsbn13IsAllowed() {
        super.validationTest(Isbn13WithSeparatorsTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn13IsAllowed() {
        for (Isbn13WithSeparatorsTestBean testBean : Isbn13WithSeparatorsTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn13IsWrong() {
        for (Isbn13WithSeparatorsTestBean testBean : Isbn13WithSeparatorsTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13Validator");
        }
    }

    @Test
    public final void testToSmallIsbn13IsWrong() {
        for (Isbn13WithSeparatorsTestBean testBean : Isbn13WithSeparatorsTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIsbn13IsWrong() {
        for (Isbn13WithSeparatorsTestBean testBean : Isbn13WithSeparatorsTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testNotNumericIsbn13IsWrong() {
        for (Isbn13WithSeparatorsTestBean testBean : Isbn13WithSeparatorsTestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13Validator");
        }
    }
}

