/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn13TestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn13TestCases;
import org.junit.Test;

public class Isbn13Test
extends AbstractValidationTest<Isbn13TestBean> {
    @Test
    public final void testEmptyIsbn13IsAllowed() {
        super.validationTest(Isbn13TestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn13IsAllowed() {
        for (Isbn13TestBean testBean : Isbn13TestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn13IsWrong() {
        for (Isbn13TestBean testBean : Isbn13TestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13Validator");
        }
    }

    @Test
    public final void testToSmallIsbn13IsWrong() {
        for (Isbn13TestBean testBean : Isbn13TestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIsbn13IsWrong() {
        for (Isbn13TestBean testBean : Isbn13TestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testNotNumericIsbn13IsWrong() {
        for (Isbn13TestBean testBean : Isbn13TestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13Validator");
        }
    }
}

