/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn13FormatedTestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn13FormatedTestCases;
import org.junit.Test;

public class Isbn13FormatedTest
extends AbstractValidationTest<Isbn13FormatedTestBean> {
    @Test
    public final void testEmptyIsbn13IsAllowed() {
        super.validationTest(Isbn13FormatedTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn13IsAllowed() {
        for (Isbn13FormatedTestBean testBean : Isbn13FormatedTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn13IsWrong() {
        for (Isbn13FormatedTestBean testBean : Isbn13FormatedTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13FormatedValidator");
        }
    }

    @Test
    public final void testToSmallIsbn13IsWrong() {
        for (Isbn13FormatedTestBean testBean : Isbn13FormatedTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigIsbn13IsWrong() {
        for (Isbn13FormatedTestBean testBean : Isbn13FormatedTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testWrongFormatIsbn13IsWrong() {
        for (Isbn13FormatedTestBean testBean : Isbn13FormatedTestCases.getWrongFormatedTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn13FormatedValidator");
        }
    }
}

