/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn10WithSeparatorsTestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn10WithSeparatorsTestCases;
import org.junit.Test;

public class Isbn10WithSeparatorsTest
extends AbstractValidationTest<Isbn10WithSeparatorsTestBean> {
    @Test
    public final void testEmptyIsbn10IsAllowed() {
        super.validationTest(Isbn10WithSeparatorsTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn10IsAllowed() {
        for (Isbn10WithSeparatorsTestBean testBean : Isbn10WithSeparatorsTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn10IsWrong() {
        for (Isbn10WithSeparatorsTestBean testBean : Isbn10WithSeparatorsTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10Validator");
        }
    }

    @Test
    public final void testToSmallIsbn10IsWrong() {
        for (Isbn10WithSeparatorsTestBean testBean : Isbn10WithSeparatorsTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIsbn10IsWrong() {
        for (Isbn10WithSeparatorsTestBean testBean : Isbn10WithSeparatorsTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testNotNumericIsbn10IsWrong() {
        for (Isbn10WithSeparatorsTestBean testBean : Isbn10WithSeparatorsTestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10Validator");
        }
    }
}

