/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn10TestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn10TestCases;
import org.junit.Test;

public class Isbn10Test
extends AbstractValidationTest<Isbn10TestBean> {
    @Test
    public final void testEmptyIsbn10IsAllowed() {
        super.validationTest(Isbn10TestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn10IsAllowed() {
        for (Isbn10TestBean testBean : Isbn10TestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn10IsWrong() {
        for (Isbn10TestBean testBean : Isbn10TestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10Validator");
        }
    }

    @Test
    public final void testToSmallIsbn10IsWrong() {
        for (Isbn10TestBean testBean : Isbn10TestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIsbn10IsWrong() {
        for (Isbn10TestBean testBean : Isbn10TestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testNotNumericIsbn10IsWrong() {
        for (Isbn10TestBean testBean : Isbn10TestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10Validator");
        }
    }
}

