/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Isbn10FormatedTestBean;
import de.knightsoftnet.validators.shared.testcases.Isbn10FormatedTestCases;
import org.junit.Test;

public class Isbn10FormatedTest
extends AbstractValidationTest<Isbn10FormatedTestBean> {
    @Test
    public final void testEmptyIsbn10IsAllowed() {
        super.validationTest(Isbn10FormatedTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIsbn10IsAllowed() {
        for (Isbn10FormatedTestBean testBean : Isbn10FormatedTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumIsbn10IsWrong() {
        for (Isbn10FormatedTestBean testBean : Isbn10FormatedTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10FormatedValidator");
        }
    }

    @Test
    public final void testToSmallIsbn10IsWrong() {
        for (Isbn10FormatedTestBean testBean : Isbn10FormatedTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigIsbn10IsWrong() {
        for (Isbn10FormatedTestBean testBean : Isbn10FormatedTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testNotNumericIsbn10IsWrong() {
        for (Isbn10FormatedTestBean testBean : Isbn10FormatedTestCases.getWrongFormatedTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Isbn10FormatedValidator");
        }
    }
}

