/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.IbanWithSpacesTestBean;
import de.knightsoftnet.validators.shared.testcases.IbanWithSpacesTestCases;
import org.junit.Test;

public class IbanWithSpacesTest
extends AbstractValidationTest<IbanWithSpacesTestBean> {
    @Test
    public final void testEmptyIbanIsAllowed() {
        super.validationTest(IbanWithSpacesTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIbanIsAllowed() {
        for (IbanWithSpacesTestBean testBean : IbanWithSpacesTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryIbanIsWrong() {
        for (IbanWithSpacesTestBean testBean : IbanWithSpacesTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanValidator");
        }
    }

    @Test
    public final void testToSmallIbanIsWrong() {
        for (IbanWithSpacesTestBean testBean : IbanWithSpacesTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIbanIsWrong() {
        for (IbanWithSpacesTestBean testBean : IbanWithSpacesTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testChecksumErrorIbanIsWrong() {
        for (IbanWithSpacesTestBean testBean : IbanWithSpacesTestCases.getWrongChecksumTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanValidator");
        }
    }
}

