/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.IbanTestBean;
import de.knightsoftnet.validators.shared.testcases.IbanTestCases;
import org.junit.Test;

public class IbanTest
extends AbstractValidationTest<IbanTestBean> {
    @Test
    public final void testEmptyIbanIsAllowed() {
        super.validationTest(IbanTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIbanIsAllowed() {
        for (IbanTestBean testBean : IbanTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryIbanIsWrong() {
        for (IbanTestBean testBean : IbanTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanValidator");
        }
    }

    @Test
    public final void testToSmallIbanIsWrong() {
        for (IbanTestBean testBean : IbanTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testToBigIbanIsWrong() {
        for (IbanTestBean testBean : IbanTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.SizeWithoutSeparatorsValidator");
        }
    }

    @Test
    public final void testChecksumErrorIbanIsWrong() {
        for (IbanTestBean testBean : IbanTestCases.getWrongChecksumTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanValidator");
        }
    }
}

