/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.IbanFormatedTestBean;
import de.knightsoftnet.validators.shared.testcases.IbanFormatedTestCases;
import org.junit.Test;

public class IbanFormatedTest
extends AbstractValidationTest<IbanFormatedTestBean> {
    @Test
    public final void testEmptyIbanIsAllowed() {
        super.validationTest(IbanFormatedTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectIbanIsAllowed() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryIbanIsWrong() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanFormatedValidator");
        }
    }

    @Test
    public final void testToSmallIbanIsWrong() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigIbanIsWrong() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testChecksumErrorIbanIsWrong() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getWrongChecksumTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanFormatedValidator");
        }
    }

    @Test
    public final void testWrongformatedIbanIsWrong() {
        for (IbanFormatedTestBean testBean : IbanFormatedTestCases.getWrongFormatedTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.IbanFormatedValidator");
        }
    }
}

