/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.GtinTestBean;
import de.knightsoftnet.validators.shared.testcases.GtinTestCases;
import org.junit.Test;

public class GtinTest
extends AbstractValidationTest<GtinTestBean> {
    @Test
    public final void testEmptyGtinIsAllowed() {
        super.validationTest(GtinTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectGtinIsAllowed() {
        for (GtinTestBean testBean : GtinTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumGtinIsWrong() {
        for (GtinTestBean testBean : GtinTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.GtinValidator");
        }
    }

    @Test
    public final void testWrongSizeGtinIsWrong() {
        for (GtinTestBean testBean : GtinTestCases.getWrongSizeTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }

    @Test
    public final void testNotNumericGtinIsWrong() {
        for (GtinTestBean testBean : GtinTestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }
}

