/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Gtin8TestBean;
import de.knightsoftnet.validators.shared.testcases.Gtin8TestCases;
import org.junit.Test;

public class Gtin8Test
extends AbstractValidationTest<Gtin8TestBean> {
    @Test
    public final void testEmptyGtin8IsAllowed() {
        super.validationTest(Gtin8TestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectGtin8IsAllowed() {
        for (Gtin8TestBean testBean : Gtin8TestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumGtin8IsWrong() {
        for (Gtin8TestBean testBean : Gtin8TestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Gtin8Validator");
        }
    }

    @Test
    public final void testToSmallGtin8IsWrong() {
        for (Gtin8TestBean testBean : Gtin8TestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigGtin8IsWrong() {
        for (Gtin8TestBean testBean : Gtin8TestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }

    @Test
    public final void testNotNumericGtin8IsWrong() {
        for (Gtin8TestBean testBean : Gtin8TestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }
}

