/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.Gtin13TestBean;
import de.knightsoftnet.validators.shared.testcases.Gtin13TestCases;
import org.junit.Test;

public class Gtin13Test
extends AbstractValidationTest<Gtin13TestBean> {
    @Test
    public final void testEmptyGtin13IsAllowed() {
        super.validationTest(Gtin13TestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectGtin13IsAllowed() {
        for (Gtin13TestBean testBean : Gtin13TestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumGtin13IsWrong() {
        for (Gtin13TestBean testBean : Gtin13TestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.Gtin13Validator");
        }
    }

    @Test
    public final void testToSmallGtin13IsWrong() {
        for (Gtin13TestBean testBean : Gtin13TestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigGtin13IsWrong() {
        for (Gtin13TestBean testBean : Gtin13TestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }

    @Test
    public final void testNotNumericGtin13IsWrong() {
        for (Gtin13TestBean testBean : Gtin13TestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }
}

