/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.GlnTestBean;
import de.knightsoftnet.validators.shared.testcases.GlnTestCases;
import org.junit.Test;

public class GlnTest
extends AbstractValidationTest<GlnTestBean> {
    @Test
    public final void testEmptyGlnIsAllowed() {
        super.validationTest(GlnTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectGlnIsAllowed() {
        for (GlnTestBean testBean : GlnTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongChecksumGlnIsWrong() {
        for (GlnTestBean testBean : GlnTestCases.getWrongTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.GlnValidator");
        }
    }

    @Test
    public final void testToSmallGlnIsWrong() {
        for (GlnTestBean testBean : GlnTestCases.getToSmallTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence");
        }
    }

    @Test
    public final void testToBigGlnIsWrong() {
        for (GlnTestBean testBean : GlnTestCases.getToBigTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }

    @Test
    public final void testNotNumericGlnIsWrong() {
        for (GlnTestBean testBean : GlnTestCases.getNotNumericTestBeans()) {
            super.validationTest(testBean, false, "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence");
        }
    }
}

