/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.BicValueTestBean;
import de.knightsoftnet.validators.shared.testcases.BicValueTestCases;
import org.junit.Test;

public class BicValueTest
extends AbstractValidationTest<BicValueTestBean> {
    @Test
    public final void testEmptyBicIsAllowed() {
        super.validationTest(BicValueTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectBicIsAllowed() {
        for (BicValueTestBean testBean : BicValueTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryBicIsWrong() {
        for (BicValueTestBean testBean : BicValueTestCases.getWrongCountryTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BicValueValidator");
        }
    }

    @Test
    public final void testLowerCaseBicIsWrong() {
        for (BicValueTestBean testBean : BicValueTestCases.getWrongFormatTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BicValueValidator");
        }
    }

    @Test
    public final void testToShortBicIsWrong() {
        for (BicValueTestBean testBean : BicValueTestCases.getWrongToShortTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }

    @Test
    public final void testToLongBicIsWrong() {
        for (BicValueTestBean testBean : BicValueTestCases.getWrongToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }
}

