/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.BicTestBean;
import de.knightsoftnet.validators.shared.testcases.BicTestCases;
import org.junit.Test;

public class BicTest
extends AbstractValidationTest<BicTestBean> {
    @Test
    public final void testEmptyBicIsAllowed() {
        super.validationTest(BicTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectBicIsAllowed() {
        for (BicTestBean testBean : BicTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryBicIsWrong() {
        for (BicTestBean testBean : BicTestCases.getWrongCountryTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BicValidator");
        }
    }

    @Test
    public final void testLowerCaseBicIsWrong() {
        for (BicTestBean testBean : BicTestCases.getWrongFormatTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BicValidator");
        }
    }

    @Test
    public final void testToShortBicIsWrong() {
        for (BicTestBean testBean : BicTestCases.getWrongToShortTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }

    @Test
    public final void testToLongBicIsWrong() {
        for (BicTestBean testBean : BicTestCases.getWrongToBigTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.AlternateSizeValidator");
        }
    }
}

