/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import de.knightsoftnet.validators.server.AbstractValidationTest;
import de.knightsoftnet.validators.shared.beans.BankCountryTestBean;
import de.knightsoftnet.validators.shared.testcases.BankCountryTestCases;
import org.junit.Test;

public class BankCountryTest
extends AbstractValidationTest<BankCountryTestBean> {
    @Test
    public final void testEmptyBankCountryIsAllowed() {
        super.validationTest(BankCountryTestCases.getEmptyTestBean(), true, null);
    }

    @Test
    public final void testCorrectBankCountryIsAllowed() {
        for (BankCountryTestBean testBean : BankCountryTestCases.getCorrectTestBeans()) {
            super.validationTest(testBean, true, null);
        }
    }

    @Test
    public final void testWrongCountryBankCountryIsWrong() {
        for (BankCountryTestBean testBean : BankCountryTestCases.getWrongCountryTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BankCountryValidator");
        }
    }

    @Test
    public final void testWrongCountryBankCountryIbanIsWrong() {
        for (BankCountryTestBean testBean : BankCountryTestCases.getWrongIbanCountryTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BankCountryValidator");
        }
    }

    @Test
    public final void testWrongCountryBankCountryBicIsWrong() {
        for (BankCountryTestBean testBean : BankCountryTestCases.getWrongBicCountryTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BankCountryValidator");
        }
    }

    @Test
    public final void testWrongBicIbanRelationBicIsWrong() {
        for (BankCountryTestBean testBean : BankCountryTestCases.getWrongBicForIbanTestBeans()) {
            super.validationTest(testBean, false, "de.knightsoftnet.validators.shared.impl.BankCountryValidator");
        }
    }
}

