/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.server;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public abstract class AbstractValidationTest<E> {
    private static final Logger LOG = LogManager.getLogger(AbstractValidationTest.class);
    protected static final String SIZE_VALIDATOR = "org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence";
    protected static final String DIGITS_VALIDATOR = "org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence";

    public final Set<ConstraintViolation<E>> validationTest(E pbean, boolean pshouldBeOk, String pexcpetedValidationClass) {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set cv1 = validator.validate(pbean, new Class[0]);
        if (pshouldBeOk) {
            Assert.assertTrue((String)("Should have no validation error " + pbean.toString()), (boolean)cv1.isEmpty());
        } else {
            Assert.assertFalse((String)("Should have a validation error " + pbean.toString()), (boolean)cv1.isEmpty());
        }
        for (ConstraintViolation violation : cv1) {
            Assert.assertEquals((String)"Should be reported by special validator", (Object)pexcpetedValidationClass, (Object)((Class)violation.getConstraintDescriptor().getConstraintValidatorClasses().get(0)).getName());
            LOG.debug("Error Message of type " + violation.getConstraintDescriptor().getConstraintValidatorClasses() + " for field \"" + violation.getPropertyPath().toString() + "\" with value \"" + pbean.toString() + "\", message: " + violation.getMessage());
        }
        return cv1;
    }
}

