/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.validators.server.data;

import de.knightsoftnet.validators.shared.data.BankAccountBicSharedConstants;

/**
 * Read gwt constants from properties file on server side.
 *
 * @author Manfred Tremmel
 *
 */
public class CreateBankAccountBicMapConstantsClass extends CreateClassHelper {

  private static final String[] COUNTRIES = {"AT", "DE"};
  private static volatile BankAccountBicConstantsImpl bicMapConstants = null;

  /**
   * Instantiates a class via deferred binding.
   *
   * @return the new instance, which must be cast to the requested class
   */
  public static BankAccountBicSharedConstants create() {
    if (bicMapConstants == null) { // NOPMD it's thread save!
      synchronized (BankAccountBicConstantsImpl.class) {
        if (bicMapConstants == null) {
          final BankAccountBicConstantsImpl bicMapConstantsTmp = new BankAccountBicConstantsImpl();
          for (final String country : COUNTRIES) {
            bicMapConstantsTmp.addBankAccounts(country,
                readMapFromProperties("BankAccountBic" + country + "Constants", "bankAccounts"));
          }
          bicMapConstants = bicMapConstantsTmp;
        }
      }
    }
    return bicMapConstants;
  }
}
