/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.gwtp.spring.annotation.processor;

import de.knightsoftnet.validators.shared.PostalCode;
import de.knightsoftnet.validators.shared.data.CountryEnum;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

@Embeddable
@PostalCode(fieldCountryCode="countryCode", fieldPostalCode="postalCode")
public class PostalAddress {
    public static final int LENGTH_DEFAULT = 255;
    public static final int LENGTH_STREET_NUMBER = 10;
    public static final int LENGTH_POSTAL_CODE = 10;
    @Size(max=255)
    @NotEmpty
    private @Size(max=255) @NotEmpty String street;
    @Size(max=10)
    @NotEmpty
    private @Size(max=10) @NotEmpty String streetNumber;
    @Size(max=10)
    @NotEmpty
    private @Size(max=10) @NotEmpty String postalCode;
    @Size(max=255)
    @NotEmpty
    private @Size(max=255) @NotEmpty String locality;
    @NotNull
    private CountryEnum countryCode;
    @Size(max=255)
    private @Size(max=255) String region;

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public CountryEnum getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryEnum countryCode) {
        this.countryCode = countryCode;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String toString() {
        return "PostalAddress [street=" + this.street + ", streetNumber=" + this.streetNumber + ", postalCode=" + this.postalCode + ", locality=" + this.locality + ", countryCode=" + String.valueOf(this.countryCode) + ", region=" + this.region + "]";
    }
}

