/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.gwtp.spring.annotation.processor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.knightsoftnet.gwtp.spring.annotation.processor.CostCenterEntity;
import de.knightsoftnet.gwtp.spring.annotation.processor.EmailData;
import de.knightsoftnet.gwtp.spring.annotation.processor.PostalAddress;
import de.knightsoftnet.gwtp.spring.annotation.processor.SalutationEnum;
import de.knightsoftnet.gwtp.spring.shared.data.jpa.domain.AbstractPersistable;
import de.knightsoftnet.validators.shared.Email;
import de.knightsoftnet.validators.shared.PhoneNumberValue;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
@PhoneNumberValue.List(value={@PhoneNumberValue(fieldCountryCode="postalAddress.countryCode", fieldPhoneNumber="phoneNumber", allowCommon=false, allowDin5008=false, allowE123=false, allowUri=false, allowMs=true)})
public class Person
extends AbstractPersistable<Long> {
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private SalutationEnum salutation;
    @NotEmpty
    @Size(max=50)
    private @NotEmpty @Size(max=50) String firstName;
    @NotEmpty
    @Size(max=50)
    private @NotEmpty @Size(max=50) String lastName;
    @Email
    private String email;
    @PastOrPresent
    private LocalDate birthday;
    private String phoneNumber;
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    @JoinColumn(name="cost_center_id", nullable=false, updatable=true)
    @NotNull
    @Valid
    private CostCenterEntity costCenter;
    @NotNull
    @Valid
    private PostalAddress postalAddress = new PostalAddress();
    @OneToMany(mappedBy="person", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotNull
    @Valid
    @Size(min=1)
    private final @NotNull @Valid @Size(min=1) List<EmailData> emails = new ArrayList<EmailData>();

    public SalutationEnum getSalutation() {
        return this.salutation;
    }

    public void setSalutation(SalutationEnum salutation) {
        this.salutation = salutation;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public LocalDate getBirthday() {
        return this.birthday;
    }

    public void setBirthday(LocalDate birthday) {
        this.birthday = birthday;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public CostCenterEntity getCostCenter() {
        return this.costCenter;
    }

    public void setCostCenter(CostCenterEntity costCenter) {
        this.costCenter = costCenter;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        this.postalAddress = postalAddress;
    }

    public List<EmailData> getEmails() {
        this.emails.forEach(email -> email.setPerson(this));
        return this.emails;
    }

    public void setEmails(List<EmailData> emails) {
        this.emails.clear();
        if (emails != null && emails.size() > 0) {
            emails.forEach(email -> email.setPerson(this));
            this.emails.addAll(emails);
        }
    }

    public String toString() {
        return "Person [salutation=" + String.valueOf((Object)this.salutation) + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", birthday=" + String.valueOf(this.birthday) + ", phoneNumber=" + this.phoneNumber + ", costCenter=" + String.valueOf((Object)this.costCenter) + ", postalAddress=" + String.valueOf(this.postalAddress) + ", emails=" + String.valueOf(this.emails) + "]";
    }
}

