package de.knightsoftnet.mtwidgets.client.ui.widget.resourceloader;

import de.knightsoftnet.mtwidgets.client.jswrapper.Webshims;

import com.google.gwt.core.client.GWT;

import elemental2.core.Global;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import elemental2.dom.HTMLScriptElement;
import elemental2.dom.NodeList;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class WebshimResources {

  private static final String POLIFILLER_URL = ((JsWebshimResourceDefinitionInterface) GWT
      .create(JsWebshimResourceDefinitionInterface.class)).getWebshimPath();

  private static boolean initializationStarted = false;

  private static Event rememberEvent;
  private static List<EventListener> eventLisenerQueue = new ArrayList<>();

  /**
   * async load of resources.
   *
   * @param function function to call on load
   */
  public static void whenReady(final EventListener function) {
    WebshimResources.eventLisenerQueue.add(function);
    if (WebshimResources.initializationStarted || WebshimResources.isInHeader()) {
      if (WebshimResources.isInitialized()) {
        WebshimResources.eventLisenerQueue
            .forEach(action -> action.handleEvent(WebshimResources.rememberEvent));
        WebshimResources.eventLisenerQueue.clear();
      }
      return;
    }
    WebshimResources.initializationStarted = true;

    JQueryResources.whenReady(event -> {

      final HTMLScriptElement webshimScript =
          (HTMLScriptElement) DomGlobal.document.createElement(JsResources.TAG_TYPE);
      webshimScript.src = POLIFILLER_URL;
      webshimScript.type = JsResources.SCRIPT_TYPE;

      DomGlobal.document.head.appendChild(webshimScript);

      webshimScript.addEventListener("load", event2 -> {
        Webshims.setOptions(Global.JSON.parse("{\n" //
            + "  \"forms-ext\": {\n" //
            + "    \"replaceUI\": true\n" //
            + "  }\n" //
            + "}"));
        Webshims.polyfill("forms forms-ext");
        WebshimResources.eventLisenerQueue.forEach(action -> action.handleEvent(event2));
        WebshimResources.eventLisenerQueue.clear();
        WebshimResources.rememberEvent = event2;
      });

    });
  }

  /**
   * check if script is available and initialized.
   *
   * @return true if it exists
   */
  public static boolean isInitialized() {
    final boolean loaded =
        WebshimResources.rememberEvent != null || StringUtils.isEmpty(POLIFILLER_URL);
    return loaded || WebshimResources.isInHeader();
  }

  /**
   * check if script is already in the header.
   *
   * @return true if it exists
   */
  public static boolean isInHeader() {
    final NodeList<Element> linkList =
        DomGlobal.document.head.getElementsByTagName(JsResources.TAG_TYPE);
    return linkList.asList().stream()
        .filter(element -> StringUtils.equals(((HTMLScriptElement) element).src, POLIFILLER_URL))
        .findFirst().isPresent();
  }
}
