/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.mtwidgets.client.ui.widget.helper;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.text.shared.Renderer;

import org.apache.commons.lang3.StringUtils;

/**
 * render double value to currency.
 *
 * @author Manfred Tremmel
 */
public class PercentDoubleRenderer extends AbstractRenderer<Double> {

  private static volatile PercentDoubleRenderer instanceRenderer = null;

  /**
   * returns the instance.
   *
   * @return CurrencyDoubleRenderer
   */
  public static final Renderer<Double> instance() { // NOPMD it's thread save!
    if (instanceRenderer == null) {
      synchronized (PercentDoubleRenderer.class) {
        if (instanceRenderer == null) {
          instanceRenderer = new PercentDoubleRenderer();
        }
      }
    }
    return instanceRenderer;
  }

  @Override
  public String render(final Double pobject) {
    if (pobject == null) {
      return StringUtils.EMPTY;
    }
    return NumberFormat.getPercentFormat().format(pobject);
  }
}
