/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.mtwidgets.client.ui.widget.helper;

import com.google.gwt.user.client.Element;

import elemental2.dom.HTMLElement;

/**
 * cast elemental2 HTMLElement to old gwt client Element and back.
 *
 * @author Manfred Tremmel
 *
 */
@SuppressWarnings("deprecation")
public final class ElementCast {

  private ElementCast() {
    super();
  }

  /**
   * cast elemental2 HTMLElement to gwt client Element.
   *
   * @param pelement element to cast
   * @return casted element
   */
  public static native Element cast(final HTMLElement pelement) /*-{
    return pelement;
  }-*/;

  /**
   * cast gwt client Element to elemental2 HTMLElement.
   *
   * @param pelement element to cast
   * @return casted element
   */
  public static native HTMLElement cast(final Element pelement) /*-{
    return pelement;
  }-*/;
}
