/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.mtwidgets.client.ui.widget;

import de.knightsoftnet.validators.client.rest.api.PhoneNumberServiceAsync;
import de.knightsoftnet.validators.client.rest.api.ServiceFactory;
import de.knightsoftnet.validators.client.rest.helper.FutureResult;
import de.knightsoftnet.validators.shared.data.ValueWithPos;
import de.knightsoftnet.validators.shared.data.ValueWithPosAndCountry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.SuggestOracle;

import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLInputElement;

import org.apache.commons.lang3.StringUtils;
import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * abstract phone number suggest widget with rest calls.
 *
 * @deprecated As of release 1.2.0, replaced by @{AbstractPhoneNumberSuggestBox}
 * @author Manfred Tremmel
 *
 */
@Deprecated
public abstract class AbstractPhoneNumberRestSuggestBox extends AbstractFormatingSuggestBox {

  protected final PhoneNumberServiceAsync service;
  protected final MethodCallback<ValueWithPos<String>> callback;
  protected TakesValue<?> countryCodeField;
  private String valueBeforeFormat;

  /**
   * cache map.
   */
  final LoadingCache<ValueWithPosAndCountry<String>, FutureResult<ValueWithPos<String>>> cache;


  /**
   * default constructor.
   */
  public AbstractPhoneNumberRestSuggestBox(final SuggestOracle poracle) {
    super(poracle, new TextBoxWithFormating(
        (HTMLInputElement) DomGlobal.document.createElement("input"), "tel"));
    ((TextBoxWithFormating) getValueBox()).setFormating(this);
    setAutocomplete("off");
    service = ServiceFactory.getPhoneNumberService();
    callback = new MethodCallback<ValueWithPos<String>>() {

      @Override
      public void onFailure(final Method pmethod, final Throwable pexception) {
        GWT.log(pexception.getMessage(), pexception);
      }

      @Override
      public void onSuccess(final Method pmethod, final ValueWithPos<String> presponse) {
        if (presponse != null && StringUtils.isNotEmpty(presponse.getValue())
            && (presponse.getOriginalValue() == null
                || StringUtils.equals(presponse.getOriginalValue(), valueBeforeFormat))) {
          AbstractPhoneNumberRestSuggestBox.this.setTextWithPos(presponse, true);
        }
      }
    };
    cache = CacheBuilder.newBuilder().maximumSize(10000).expireAfterWrite(10, TimeUnit.DAYS).build(
        new CacheLoader<ValueWithPosAndCountry<String>, FutureResult<ValueWithPos<String>>>() {

          @Override
          public FutureResult<ValueWithPos<String>> load(
              final ValueWithPosAndCountry<String> pkey) {
            final FutureResult<ValueWithPos<String>> result = new FutureResult<>();
            result.addCallback(callback);
            try {
              AbstractPhoneNumberRestSuggestBox.this.formatValue(pkey, result);
            } catch (final ExecutionException e) {
              GWT.log(e.getMessage(), e);
            }
            return result;
          }
        });
  }

  @Override
  public void formatValue(final ValueWithPos<String> pvalue, final boolean fireEvents) {
    if (pvalue == null || StringUtils.isEmpty(pvalue.getValue())) {
      this.setValue(StringUtils.EMPTY);
    } else {
      final ValueWithPosAndCountry<String> unformatedEntry = new ValueWithPosAndCountry<>(
          pvalue.getValue(), pvalue.getPos(), Objects.toString(countryCodeField.getValue()),
          LocaleInfo.getCurrentLocale().getLocaleName());
      valueBeforeFormat = pvalue.getValue();
      try {
        final FutureResult<ValueWithPos<String>> result = cache.get(unformatedEntry);
        if (result.isDone()) {
          setTextWithPos(result.get(), fireEvents);
        }
      } catch (final ExecutionException e) {
        GWT.log(e.getMessage(), e);
      }
    }
  }

  public abstract void formatValue(ValueWithPosAndCountry<String> pkey,
      FutureResult<ValueWithPos<String>> presult) throws ExecutionException;

  /**
   * set reference to a field which contains the country code.
   *
   * @param pcountryCodeField field which contains the country code
   */
  public final void setCountryCodeReferenceField(final TakesValue<?> pcountryCodeField) {
    countryCodeField = pcountryCodeField;
  }

  @Override
  public boolean isAllowedCharacter(final char pcharacter) {
    return pcharacter >= '0' && pcharacter <= '9' || isFormatingCharacter(pcharacter);
  }

  @Override
  public boolean isCharacterToReplace(final char pcharacter) {
    return false;
  }

  @Override
  public char replaceCharacter(final char pcharacter) {
    return pcharacter;
  }
}
