/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.validators.shared.beans;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;

/**
 * test with getter that doesn't match the naming conventions.
 */
public class Bug28TestBean {

  @Min(1)
  @Max(5)
  private final int number;

  public Bug28TestBean(final int number) {
    super();
    this.number = number;
  }

  public final int getPropertyNumber() {
    return this.number;
  }

  @Override
  public String toString() {
    return "Bug28TestBean [number=" + this.number + "]";
  }
}
