/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.Sets;
import de.knightsoftnet.validators.annotation.processor.ApUtils;
import de.knightsoftnet.validators.annotation.processor.GwtSpecificValidatorClassCreator;
import de.knightsoftnet.validators.annotation.processor.GwtSpecificValidatorInterfaceCreator;
import de.knightsoftnet.validators.annotation.processor.ValidatorCreator;
import de.knightsoftnet.validators.annotation.processor.ValidatorInterfaceCreator;
import de.knightsoftnet.validators.client.GwtValidation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.knightsoftnet.validators.client.GwtValidation"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class GwtSpecificValidatorCreatorProcessor
extends AbstractProcessor {
    private static final GwtSpecificValidatorInterfaceCreator INTERFACE_CREATOR = new GwtSpecificValidatorInterfaceCreator();
    private final Set<TypeMirror> validGroups = Sets.newConcurrentHashSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.size() != 1 || roundEnv == null || roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(annotations.iterator().next());
        if (annotatedElements == null || annotatedElements.size() != 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@GwtValidation must be applied to exactly one class");
            return false;
        }
        Element annotatedElement = annotatedElements.iterator().next();
        String packageName = this.processingEnv.getElementUtils().getPackageOf(annotatedElement).getQualifiedName().toString();
        GwtValidation gwtValidation = annotatedElement.getAnnotation(GwtValidation.class);
        this.validGroups.addAll(ApUtils.getTypeMirrorFromAnnotationValue(() -> gwtValidation.groups()));
        boolean generateReflectionGetter = gwtValidation.generateReflectionGetter();
        List<? extends TypeMirror> generateReflectionsFor = ApUtils.getTypeMirrorFromAnnotationValue(() -> gwtValidation.reflect());
        String[] languages = gwtValidation.languages();
        Set additionalInterfacesToCreate = Sets.newConcurrentHashSet();
        ApUtils.getTypeMirrorFromAnnotationValue(() -> gwtValidation.value()).forEach(typeMirror -> {
            INTERFACE_CREATOR.writeInterface((TypeMirror)typeMirror, this.processingEnv);
            boolean generateReflection = (generateReflectionsFor.isEmpty() || generateReflectionsFor.contains(typeMirror)) && generateReflectionGetter;
            GwtSpecificValidatorClassCreator classCreator = new GwtSpecificValidatorClassCreator(this.processingEnv, this.validGroups, gwtValidation.forceUsingGetter(), generateReflection, languages);
            additionalInterfacesToCreate.addAll(classCreator.writeClass((TypeMirror)typeMirror));
        });
        additionalInterfacesToCreate.forEach(typeMirror -> {
            INTERFACE_CREATOR.writeInterface((TypeMirror)typeMirror, this.processingEnv);
            boolean generateReflection = (generateReflectionsFor.isEmpty() || generateReflectionsFor.contains(typeMirror)) && generateReflectionGetter;
            GwtSpecificValidatorClassCreator classCreator = new GwtSpecificValidatorClassCreator(this.processingEnv, this.validGroups, gwtValidation.forceUsingGetter(), generateReflection, languages);
            classCreator.writeClass((TypeMirror)typeMirror);
        });
        ValidatorCreator validatorCreator = new ValidatorCreator();
        String interfaceName = annotatedElement.getSimpleName().toString();
        String factoryClass = annotatedElement.getEnclosingElement().getSimpleName().toString();
        validatorCreator.writeClass(packageName, interfaceName, factoryClass, gwtValidation, this.processingEnv);
        if (gwtValidation.generateValidatorFactoryInterface()) {
            ValidatorInterfaceCreator validatorInterfaceCreator = new ValidatorInterfaceCreator();
            validatorInterfaceCreator.writeInterface(packageName, factoryClass, this.processingEnv);
        }
        return true;
    }
}

