/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptorImpl;
import de.knightsoftnet.validators.annotation.processor.TypeElementPropertyDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeElementPropertyDescriptorImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;

public class TypeUtils {
    public static String getClassName(TypeElement element) {
        Element currElement = element;
        String result = element.getSimpleName().toString();
        while (currElement.getEnclosingElement() != null) {
            if ((currElement = currElement.getEnclosingElement()) instanceof TypeElement) {
                result = currElement.getSimpleName() + "$" + result;
                continue;
            }
            if (!(currElement instanceof PackageElement) || !StringUtils.isNotEmpty((CharSequence)currElement.getSimpleName())) continue;
            result = ((PackageElement)currElement).getQualifiedName() + "." + result;
        }
        return result;
    }

    public static String getClassName(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                return TypeUtils.getClassName(((ArrayType)typeMirror).getComponentType()) + "[]";
            }
            case EXECUTABLE: {
                return TypeUtils.getClassName(((ExecutableType)typeMirror).getReturnType());
            }
            case DECLARED: {
                return ((DeclaredType)typeMirror).asElement().toString();
            }
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case CHAR: {
                return "char";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        return typeMirror.toString();
    }

    public static String getClassNameWithProperties(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                return TypeUtils.getClassName(((ArrayType)typeMirror).getComponentType()) + "[]";
            }
            case EXECUTABLE: {
                return TypeUtils.getClassName(((ExecutableType)typeMirror).getReturnType());
            }
            case DECLARED: {
                String type = CollectionUtils.isEmpty(((DeclaredType)typeMirror).getTypeArguments()) ? "" : ((DeclaredType)typeMirror).getTypeArguments().stream().map(TypeUtils::getClassNameWithProperties).collect(Collectors.joining(", ", "<", ">"));
                return ((DeclaredType)typeMirror).asElement().toString() + type;
            }
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case CHAR: {
                return "char";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        return typeMirror.toString();
    }

    public static String getClassNameWithPropertiesOfElement(TypeMirror typeMirror, Element field) {
        TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        if (typeElement.getEnclosedElements().contains(field)) {
            return TypeUtils.getClassNameWithProperties(typeMirror);
        }
        if (typeElement.getSuperclass() instanceof NoType) {
            return null;
        }
        return TypeUtils.getClassNameWithPropertiesOfElement(typeElement.getSuperclass(), field);
    }

    public static String getClassNameWithPropertiesOfElementNoType(TypeMirror typeMirror, Element field) {
        TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        if (typeElement.getEnclosedElements().contains(field)) {
            return TypeUtils.getClassName(typeMirror);
        }
        if (typeElement.getSuperclass() instanceof NoType) {
            return null;
        }
        return TypeUtils.getClassNameWithPropertiesOfElementNoType(typeElement.getSuperclass(), field);
    }

    public static boolean isBeanConstrained(TypeMirror typeMirror, Types typeUtils, Elements elementUtils) {
        return !TypeUtils.getTypeElementConstraintDescriptors(typeMirror, elementUtils, typeUtils).isEmpty() || TypeUtils.getFields(typeMirror).stream().filter(TypeUtils::hasValidAnnotation).findFirst().isPresent() || TypeUtils.getGetter(typeMirror).stream().filter(TypeUtils::hasValidAnnotation).findFirst().isPresent();
    }

    public static List<TypeElementConstraintDescriptor<?>> getTypeElementConstraintDescriptors(TypeMirror typeMirror, Elements elementUtils, Types typeUtils) {
        return TypeUtils.getTypeElementConstraintDescriptorsRecursive(((DeclaredType)typeMirror).asElement(), elementUtils, typeUtils, new ArrayList());
    }

    private static List<TypeElementConstraintDescriptor<?>> getTypeElementConstraintDescriptorsRecursive(Element element, Elements elementUtils, Types typeUtils, List<TypeElementConstraintDescriptor<?>> constraintDescriptors) {
        constraintDescriptors.addAll(TypeElementConstraintDescriptorImpl.createComposingConstraintsForElement(element, elementUtils, ConstraintLocation.ConstraintLocationKind.TYPE, Collections.emptyMap()));
        if (!(element instanceof TypeElement) || ((TypeElement)element).getSuperclass() instanceof NoType) {
            return constraintDescriptors;
        }
        return TypeUtils.getTypeElementConstraintDescriptorsRecursive(typeUtils.asElement(((TypeElement)element).getSuperclass()), elementUtils, typeUtils, constraintDescriptors);
    }

    public static List<TypeElementPropertyDescriptor> getTypeElementProperties(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        return TypeUtils.getRecursiveEnclosedElements(typeMirror).stream().filter(subElement -> (subElement.getKind() == ElementKind.FIELD || TypeUtils.isGetter(subElement)) && TypeUtils.hasValidationAnnotation(subElement)).map(subElement -> new TypeElementPropertyDescriptorImpl((Element)subElement, (DeclaredType)typeMirror, processingEnv, ConstraintLocation.ConstraintLocationKind.FIELD)).collect(Collectors.toList());
    }

    private static boolean hasValidationAnnotation(Element element) {
        return element.getAnnotationMirrors().stream().filter(TypeUtils::isValidationAnnotation).count() != 0L;
    }

    private static boolean isValidationAnnotation(AnnotationMirror annotationMirror) {
        return "javax.validation.Valid".contentEquals(annotationMirror.getAnnotationType().toString()) || annotationMirror.getAnnotationType().asElement().getAnnotationMirrors().stream().filter(entry -> "javax.validation.Constraint".equals(entry.getAnnotationType().asElement().toString())).count() != 0L;
    }

    private static boolean hasValidAnnotation(Element element) {
        return element.getAnnotationMirrors().stream().filter(annotationMirror -> "javax.validation.Valid".contentEquals(annotationMirror.getAnnotationType().toString())).findFirst().isPresent();
    }

    public static List<Element> getRecursiveEnclosedElements(TypeMirror typeMirror) {
        ArrayList<Element> getterList = new ArrayList<Element>();
        return TypeUtils.getRecursiveEnclosedElements(typeMirror, getterList);
    }

    private static List<Element> getRecursiveEnclosedElements(TypeMirror typeMirror, List<Element> enclosingTypeList) {
        TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        enclosingTypeList.addAll(typeElement.getEnclosedElements());
        if (typeElement.getSuperclass() instanceof NoType) {
            return enclosingTypeList;
        }
        return TypeUtils.getRecursiveEnclosedElements(typeElement.getSuperclass(), enclosingTypeList);
    }

    public static List<String> getGetterNames(TypeMirror typeMirror) {
        return TypeUtils.getGetter(typeMirror).stream().map(TypeUtils::getterNameFromElement).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getGetter(TypeMirror typeMirror) {
        return TypeUtils.getRecursiveEnclosedElements(typeMirror).stream().filter(TypeUtils::isGetter).map(ExecutableElement.class::cast).collect(Collectors.toList());
    }

    public static Optional<ExecutableElement> getGetter(TypeMirror typeMirror, String valueName) {
        if (TypeUtils.isGetter(valueName)) {
            return TypeUtils.getGetter(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)TypeUtils.getterNameFromElement(element), (CharSequence)valueName)).findFirst();
        }
        return TypeUtils.getGetter(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)TypeUtils.valueFromGetter(TypeUtils.getterNameFromElement(element)), (CharSequence)valueName)).findFirst();
    }

    public static boolean isGetter(Element element) {
        ExecutableElement method;
        return element.getKind() == ElementKind.METHOD && !(method = (ExecutableElement)element).getModifiers().contains((Object)Modifier.PRIVATE) && method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID && TypeUtils.isGetter(method.getSimpleName().toString());
    }

    public static boolean isGetter(String elementName) {
        return StringUtils.startsWith((CharSequence)elementName, (CharSequence)"get") && StringUtils.length((CharSequence)elementName) > 3 && Character.isUpperCase(elementName.charAt(3)) || StringUtils.startsWith((CharSequence)elementName, (CharSequence)"is") && StringUtils.length((CharSequence)elementName) > 2 && Character.isUpperCase(elementName.charAt(2));
    }

    public static List<TypeMirror> getInterfaces(TypeMirror typeMirror) {
        ArrayList<TypeMirror> interfacesList = new ArrayList<TypeMirror>();
        return TypeUtils.getInterfaces(typeMirror, interfacesList);
    }

    private static List<TypeMirror> getInterfaces(TypeMirror typeMirror, List<TypeMirror> interfacesList) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
                TypeUtils.getInterfaces(typeMirror2, interfacesList);
                interfacesList.add(typeMirror2);
            }
        }
        return interfacesList;
    }

    public static List<ExecutableElement> getMethods(TypeMirror typeMirror) {
        return TypeUtils.getRecursiveEnclosedElements(typeMirror).stream().filter(element -> element.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).collect(Collectors.toList());
    }

    public static List<Element> getFields(TypeMirror typeMirror) {
        return TypeUtils.getRecursiveEnclosedElements(typeMirror).stream().filter(element -> element.getKind() == ElementKind.FIELD).collect(Collectors.toList());
    }

    public static List<AnnotationMirror> getAnnotationsForType(TypeMirror typeMirror, Types typeUtils, Elements elementUtils) {
        return TypeUtils.getAnnotationsForElement(typeUtils.asElement(typeMirror), typeUtils, elementUtils, new ArrayList<AnnotationMirror>());
    }

    public static List<AnnotationMirror> getAnnotationsForElement(Element element, Types typeUtils, Elements elementUtils) {
        return TypeUtils.getAnnotationsForElement(element, typeUtils, elementUtils, new ArrayList<AnnotationMirror>());
    }

    private static List<AnnotationMirror> getAnnotationsForElement(Element element, Types typeUtils, Elements elementUtils, List<AnnotationMirror> result) {
        for (AnnotationMirror annotationMirror : elementUtils.getAllAnnotationMirrors(element)) {
            boolean isList = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String methodName = entry.getKey().getSimpleName().toString();
                if (!"value".equals(methodName) || !(entry.getValue().getValue() instanceof List)) continue;
                for (Object annotationMirror2 : (List)entry.getValue().getValue()) {
                    if (!(annotationMirror2 instanceof AnnotationMirror)) continue;
                    isList = true;
                    result.add((AnnotationMirror)annotationMirror2);
                }
            }
            if (isList) continue;
            result.add(annotationMirror);
        }
        if (!(element instanceof TypeElement) || ((TypeElement)element).getSuperclass() instanceof NoType) {
            return result;
        }
        return TypeUtils.getAnnotationsForElement(typeUtils.asElement(((TypeElement)element).getSuperclass()), typeUtils, elementUtils, result);
    }

    public static String getterNameFromElement(Element element) {
        return ((ExecutableElement)element).getSimpleName().toString();
    }

    public static String valueFromGetter(String getterName) {
        return StringUtils.uncapitalize((String)StringUtils.removeStart((String)StringUtils.removeStart((String)getterName, (String)"get"), (String)"is"));
    }

    public static boolean hasGetter(TypeMirror typeMirror, String valueName) {
        if (TypeUtils.isGetter(valueName)) {
            return TypeUtils.getGetterNames(typeMirror).stream().filter(getterName -> StringUtils.equals((CharSequence)getterName, (CharSequence)valueName)).count() != 0L;
        }
        return TypeUtils.getGetterNames(typeMirror).stream().filter(getterName -> StringUtils.equals((CharSequence)TypeUtils.valueFromGetter(getterName), (CharSequence)valueName)).count() != 0L;
    }

    public static boolean hasField(TypeMirror typeMirror, String valueName) {
        if (TypeUtils.isGetter(valueName)) {
            return TypeUtils.getGetterNames(typeMirror).stream().filter(getterName -> StringUtils.equals((CharSequence)getterName, (CharSequence)valueName)).count() != 0L;
        }
        return TypeUtils.getFields(typeMirror).stream().map(Element::getSimpleName).filter(elementName -> StringUtils.equals((CharSequence)elementName, (CharSequence)valueName)).count() != 0L;
    }

    public static Optional<TypeMirror> getterReturnType(TypeMirror typeMirror, String valueName) {
        if (TypeUtils.isGetter(valueName)) {
            return TypeUtils.getGetter(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)TypeUtils.getterNameFromElement(element), (CharSequence)valueName)).map(ExecutableElement::getReturnType).findFirst();
        }
        return TypeUtils.getGetter(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)TypeUtils.valueFromGetter(TypeUtils.getterNameFromElement(element)), (CharSequence)valueName)).map(ExecutableElement::getReturnType).findFirst();
    }

    public static Optional<ExecutableElement> getMethod(TypeMirror typeMirror, String methodName) {
        return TypeUtils.getMethods(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)element.getSimpleName().toString(), (CharSequence)methodName)).findFirst();
    }

    public static Optional<TypeMirror> fieldType(TypeMirror typeMirror, String valueName, ProcessingEnvironment processingEnv) {
        if (TypeUtils.isGetter(valueName)) {
            return TypeUtils.getGetter(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)TypeUtils.getterNameFromElement(element), (CharSequence)valueName)).map(ExecutableElement::getReturnType).findFirst();
        }
        return TypeUtils.getFields(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)element.getSimpleName(), (CharSequence)valueName)).map(element -> processingEnv.getTypeUtils().asMemberOf((DeclaredType)typeMirror, (Element)element)).findFirst();
    }

    public static Optional<Element> fieldElementByName(TypeMirror typeMirror, String valueName) {
        return TypeUtils.getFields(typeMirror).stream().filter(element -> StringUtils.equals((CharSequence)element.getSimpleName(), (CharSequence)valueName)).findFirst();
    }

    public static String getValidationInterfaceForType(TypeMirror typeMirror, Types typeUtils) {
        return "_" + typeUtils.asElement(typeMirror).getSimpleName().toString() + "Validator";
    }

    public static String getValidationInstanceForType(TypeMirror typeMirror, Types typeUtils, Elements elementUtils) {
        String packageToGenerate = elementUtils.getPackageOf(typeUtils.asElement(typeMirror)).getQualifiedName().toString();
        if (StringUtils.isEmpty((CharSequence)packageToGenerate)) {
            return TypeUtils.getValidationInterfaceForType(typeMirror, typeUtils) + ".INSTANCE";
        }
        return packageToGenerate + "." + TypeUtils.getValidationInterfaceForType(typeMirror, typeUtils) + ".INSTANCE";
    }

    public static String getValidationClassForType(TypeMirror typeMirror, Types typeUtils, Elements elementUtils) {
        return TypeUtils.getValidationInterfaceForType(typeMirror, typeUtils) + "Impl";
    }

    public static Type getType(final TypeMirror typeMirror) {
        return new Type(){

            @Override
            public String getTypeName() {
                return typeMirror.toString();
            }
        };
    }

    public static String getElementName(TypeElementPropertyDescriptor propertyDescription) {
        if (TypeUtils.isGetter(propertyDescription.getPropertyName())) {
            return TypeUtils.valueFromGetter(propertyDescription.getPropertyName());
        }
        return propertyDescription.getPropertyName();
    }
}

