/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.TypeUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class GwtSpecificValidatorInterfaceCreator {
    public void writeInterface(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        String packageToGenerate = processingEnv.getElementUtils().getPackageOf(processingEnv.getTypeUtils().asElement(typeMirror)).getQualifiedName().toString();
        String interfaceToGenerate = TypeUtils.getValidationInterfaceForType(typeMirror, processingEnv.getTypeUtils());
        this.writeInterface(packageToGenerate, interfaceToGenerate, TypeUtils.getClassNameWithProperties(typeMirror), processingEnv);
    }

    private void writeInterface(String packageToGenerate, String interfaceToGenerate, String classToValidate, ProcessingEnvironment processingEnv) {
        try {
            JavaFileObject builderFile = processingEnv.getFiler().createSourceFile(packageToGenerate + "." + interfaceToGenerate, new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.print("package ");
                out.print(packageToGenerate);
                out.println(";");
                out.println();
                out.println("import de.knightsoftnet.validators.client.impl.GwtSpecificValidator;");
                out.println();
                out.print("public interface ");
                out.print(interfaceToGenerate);
                out.print(" extends GwtSpecificValidator<");
                out.print(classToValidate);
                out.println("> {");
                out.print("  static ");
                out.print(interfaceToGenerate);
                out.print(" INSTANCE = new ");
                out.print(interfaceToGenerate);
                out.println("Impl();");
                out.println("}");
            }
        }
        catch (FilerException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, e.getMessage());
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }
}

