/*
 * Decompiled with CFR 0.152.
 */
package de.kiridevs.kiricore.managers;

import de.kiridevs.kiricore.Prefix;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class MessageService {
    Map<String, Prefix> prefixMap;
    Map<String, String> defaultMessages;

    public MessageService(Map<String, Prefix> prefixMap, Map<String, String> defaultMessages) {
        this.prefixMap = prefixMap;
        this.defaultMessages = defaultMessages;
        if (prefixMap.get("success") == null || prefixMap.get("error") == null || prefixMap.get("info") == null) {
            throw new IllegalArgumentException("A prefix map must includeprefixes for \"success\", \"error\" and \"info\"!");
        }
    }

    private String completePreset(String presetKey, @Nullable List<String> completion) {
        if (this.defaultMessages.get(presetKey) != null) {
            String preset = this.defaultMessages.get(presetKey);
            if (completion != null) {
                String message = preset;
                for (int i = 0; i < completion.size(); ++i) {
                    String placeholder = "{" + i + "}";
                    String value = completion.get(i);
                    message = message.replace(placeholder, value);
                }
                return message;
            }
            return preset;
        }
        throw new IllegalArgumentException("No predefined message with the key \"" + presetKey + "\" was found!");
    }

    public void sendSuccessMessage(CommandSender recipient, String content) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"success").player : this.prefixMap.get((Object)"success").console;
        msg = (String)msg + content;
        recipient.sendMessage((String)msg);
    }

    public void sendSuccessMessage(CommandSender recipient, String messageKey, @Nullable List<String> completionArgs) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"success").player : this.prefixMap.get((Object)"success").console;
        msg = (String)msg + this.completePreset(messageKey, completionArgs);
        recipient.sendMessage((String)msg);
    }

    public void sendErrorMessage(CommandSender recipient, String content) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"error").player : this.prefixMap.get((Object)"error").console;
        msg = (String)msg + content;
        recipient.sendMessage((String)msg);
    }

    public void sendErrorMessage(CommandSender recipient, String messageKey, @Nullable List<String> completionArgs) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"error").player : this.prefixMap.get((Object)"error").console;
        msg = (String)msg + this.completePreset(messageKey, completionArgs);
        recipient.sendMessage((String)msg);
    }

    public void sendInfoMessage(CommandSender recipient, String content) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"info").player : this.prefixMap.get((Object)"info").console;
        msg = (String)msg + content;
        recipient.sendMessage((String)msg);
    }

    public void sendInfoMessage(CommandSender recipient, String messageKey, @Nullable List<String> completionArgs) {
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)"info").player : this.prefixMap.get((Object)"info").console;
        msg = (String)msg + this.completePreset(messageKey, completionArgs);
        recipient.sendMessage((String)msg);
    }

    public void broadcastMessage(String content) {
        Object msg = this.prefixMap.get((Object)"info").console;
        msg = (String)msg + content;
        Bukkit.getServer().broadcastMessage((String)msg);
    }

    public void broadcastMessage(String messageKey, @Nullable List<String> completionArgs) {
        Object msg = this.prefixMap.get((Object)"info").console;
        msg = (String)msg + this.completePreset(messageKey, completionArgs);
        Bukkit.getServer().broadcastMessage((String)msg);
    }

    public void sendCustomMessage(CommandSender recipient, String prefixKey, String content) {
        if (this.prefixMap.get(prefixKey) == null) {
            throw new IllegalArgumentException("No prefix was provided for key \"" + prefixKey + "\"!");
        }
        String msg = recipient instanceof Player ? this.prefixMap.get((Object)prefixKey).player : this.prefixMap.get((Object)prefixKey).console;
        recipient.sendMessage(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendCustomMessage(CommandSender recipient, String prefixKey, String messageKey, @Nullable List<String> completionArgs) {
        if (this.prefixMap.get(prefixKey) == null) throw new IllegalArgumentException("No prefix was provided for key \"" + prefixKey + "\"!");
        if (this.defaultMessages.get(messageKey) == null) throw new IllegalArgumentException("No predefined message with the key \"" + messageKey + "\" was found!");
        Object msg = recipient instanceof Player ? this.prefixMap.get((Object)prefixKey).player : this.prefixMap.get((Object)prefixKey).console;
        String preset = this.defaultMessages.get(messageKey);
        if (completionArgs != null) {
            for (int i = 0; i < completionArgs.size(); ++i) {
                String placeholder = "{" + i + "}";
                String value = completionArgs.get(i);
                preset = preset.replace(placeholder, value);
            }
        }
        msg = (String)msg + preset;
        recipient.sendMessage((String)msg);
    }
}

