/*
 * Decompiled with CFR 0.152.
 */
package de.kiridevs.kiricore.commands;

import de.kiridevs.kiricore.managers.AfkManager;
import de.kiridevs.kiricore.managers.MessageService;
import java.util.ArrayList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CMDafkList
implements CommandExecutor {
    MessageService messageService;

    public CMDafkList(MessageService messageService) {
        this.messageService = messageService;
    }

    public boolean onCommand(@NotNull CommandSender cmdSender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!cmdSender.hasPermission("kiri.core.afk.list")) {
            ArrayList<String> completionList = new ArrayList<String>();
            completionList.add("kiri.core.afk.list");
            this.messageService.sendErrorMessage(cmdSender, "noperm", completionList);
            return true;
        }
        if (args.length != 0) {
            ArrayList<String> completionList = new ArrayList<String>();
            completionList.add("/afklist");
            this.messageService.sendErrorMessage(cmdSender, "badsyntax", completionList);
            return true;
        }
        if (AfkManager.getAfkList().size() == 0) {
            this.messageService.sendErrorMessage(cmdSender, "No one is marked as AFK at the moment!");
            return true;
        }
        StringBuilder listBuilder = new StringBuilder();
        boolean isFirstRun = true;
        for (String playerName : AfkManager.getAfkList()) {
            if (!isFirstRun) {
                listBuilder.append(", ");
            } else {
                isFirstRun = false;
            }
            listBuilder.append("\u00a7r\u00a73");
            listBuilder.append(playerName);
            listBuilder.append("\u00a7r\u00a7b");
        }
        String listString = listBuilder.toString();
        this.messageService.sendInfoMessage(cmdSender, "These players are marked as AFK right now:");
        this.messageService.sendInfoMessage(cmdSender, listString);
        return true;
    }
}

