/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.inoksjavautils.transform.JsonUtils;
import de.kgrupp.monads.result.Result;
import java.io.InputStream;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonUtilsTest {
    private static final MyClass EXAMPLE = new MyClass(1, 1.0);
    private static final String EXAMPLE_STRING = "{\"anInt\":1,\"someDouble\":1.0}";

    JsonUtilsTest() {
    }

    @Test
    void convertToJsonString() {
        Result result = JsonUtils.convertToJsonString((Object)EXAMPLE);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE_STRING), (Object)result);
    }

    @Test
    void convertToJsonStringFails() {
        Result result = JsonUtils.convertToJsonString((Object)new Object(){});
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(InvalidDefinitionException.class, result.getThrowable().getClass());
    }

    @Test
    void convertToObject() {
        Result result = JsonUtils.convertToObject((String)EXAMPLE_STRING, MyClass.class);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE), (Object)result);
    }

    @Test
    void convertToObjectFail() {
        Result result = JsonUtils.convertToObject((String)"{", MyClass.class);
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(JsonEOFException.class, result.getThrowable().getClass());
    }

    @Test
    void convertToObjectAsInputStream() {
        Result result = JsonUtils.convertToObject((InputStream)((InputStream)IOUtils.stringToInputStream((String)EXAMPLE_STRING).getObject()), MyClass.class);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE), (Object)result);
    }

    @Test
    void convertToObjectUseDefaultOnError() {
        MyClass result = (MyClass)JsonUtils.convertToObjectUseDefaultOnError((String)EXAMPLE_STRING, MyClass.class, null);
        Assertions.assertEquals((Object)EXAMPLE, (Object)result);
    }

    @Test
    void convertToObjectUseDefaultOnErrorDefaultUsed() {
        MyClass result = (MyClass)JsonUtils.convertToObjectUseDefaultOnError((String)"{", MyClass.class, (Object)EXAMPLE);
        Assertions.assertEquals((Object)EXAMPLE, (Object)result);
    }

    private static class MyClass {
        private int anInt;
        private double someDouble;

        public MyClass() {
        }

        public MyClass(int anInt, double someDouble) {
            this.anInt = anInt;
            this.someDouble = someDouble;
        }

        public int getAnInt() {
            return this.anInt;
        }

        public void setAnInt(int anInt) {
            this.anInt = anInt;
        }

        public double getSomeDouble() {
            return this.someDouble;
        }

        public void setSomeDouble(double someDouble) {
            this.someDouble = someDouble;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyClass myClass = (MyClass)o;
            return this.anInt == myClass.anInt && Double.compare(myClass.someDouble, this.someDouble) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.anInt, this.someDouble);
        }
    }
}

