/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import de.kgrupp.inoksjavautils.transform.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Base64Test {
    private static final String PLAIN_TEXT = "lasdfjn329+...,-1!\"\u00a7$%&/()=??``";
    private static final byte[] PLAIN_BYTES = "lasdfjn329+...,-1!\"\u00a7$%&/()=??``".getBytes();
    private static final String ENCODED_TEXT = "bGFzZGZqbjMyOSsuLi4sLTEhIsKnJCUmLygpPT8/YGA=";
    private static final byte[] ENCODED_BYTES = "bGFzZGZqbjMyOSsuLi4sLTEhIsKnJCUmLygpPT8/YGA=".getBytes();

    Base64Test() {
    }

    @Test
    void encodeString() {
        String encoded = Base64.encode((String)PLAIN_TEXT);
        Assertions.assertEquals((Object)ENCODED_TEXT, (Object)encoded);
    }

    @Test
    void decodeString() {
        String decoded = Base64.decode((String)ENCODED_TEXT);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)decoded);
    }

    @Test
    void encodeBytes() {
        String encoded = Base64.encode((byte[])PLAIN_BYTES);
        Assertions.assertEquals((Object)ENCODED_TEXT, (Object)encoded);
    }

    @Test
    void decodeBytes() {
        String decoded = Base64.decode((byte[])ENCODED_BYTES);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)decoded);
    }

    @Test
    void encodeToBytes() {
        byte[] encoded = Base64.encodeToBytes((String)PLAIN_TEXT);
        this.assertByteArray(ENCODED_BYTES, encoded);
    }

    @Test
    void decodeToBytes() {
        byte[] decoded = Base64.decodeToBytes((String)ENCODED_TEXT);
        this.assertByteArray(PLAIN_BYTES, decoded);
    }

    private void assertByteArray(byte[] expected, byte[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((byte)expected[i], (byte)actual[i]);
        }
    }
}

