/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.resbundle;

import de.kgrupp.inoksjavautils.resbundle.IJUResourceBundle;
import de.kgrupp.inoksjavautils.resbundle.KeyProvider;
import java.time.LocalTime;
import java.util.MissingResourceException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IJUResourceBundleTest {
    private static final ConstantTest constantTest = new ConstantTest();

    IJUResourceBundleTest() {
    }

    @Test
    void getProperty() {
        String result = constantTest.getProperty(() -> "some.string");
        Assertions.assertEquals((Object)"Blaub", (Object)result);
    }

    @Test
    void getPropertyInt() {
        int result = constantTest.getPropertyInt(() -> "some.int");
        Assertions.assertEquals((int)123, (int)result);
    }

    @Test
    void getPropertyLong() {
        long result = constantTest.getPropertyLong(() -> "some.long");
        Assertions.assertEquals((long)456L, (long)result);
    }

    @Test
    void getPropertyBoolean() {
        boolean result = constantTest.getPropertyBoolean(() -> "some.boolean");
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void getPropertyLocalTime() {
        LocalTime result = constantTest.getPropertyLocalTime(() -> "some.time");
        Assertions.assertEquals((Object)LocalTime.of(12, 34, 56, 789123456), (Object)result);
    }

    @Test
    void loadingFails() {
        Assertions.assertThrows(MissingResourceException.class, () -> new IJUResourceBundle("de.kgrupp.inoksjavautils.resbundle.missingFile"));
    }

    static class ConstantTest
    extends IJUResourceBundle<KeyProvider> {
        protected ConstantTest() {
            super("de.kgrupp.inoksjavautils.resbundle.ConstantTest");
        }
    }
}

