/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.io;

import de.kgrupp.inoksjavautils.io.XmlReadWriteUtils;
import de.kgrupp.monads.result.Result;
import java.io.File;
import java.net.URL;
import javax.xml.transform.TransformerException;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

class XmlReadWriteUtilsTest {
    XmlReadWriteUtilsTest() {
    }

    @Test
    void read() {
        Result result = XmlReadWriteUtils.read((File)this.getFileInPackage("example.xml"));
        result.consumeOrFail(this::assertExampleXml);
    }

    @Test
    void readInvalidXml() {
        Result result = XmlReadWriteUtils.read((File)this.getFileInPackage("invalid-xml.xml"));
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(SAXParseException.class, result.getThrowable().getClass());
    }

    @Test
    void readSafe() {
        Result result = XmlReadWriteUtils.readSafe((File)this.getFileInPackage("example.xml"));
        result.consumeOrFail(this::assertExampleXml);
    }

    @Test
    void readSafeFileMissing() {
        Result result = XmlReadWriteUtils.readSafe((File)new File(this.getFileInPackage("").getAbsoluteFile() + "/file-missing.xml"));
        result.consumeOrFail(document -> Assertions.assertEquals((int)0, (int)document.getChildNodes().getLength()));
    }

    @Test
    void createEmptyDocument() {
        Result result = XmlReadWriteUtils.createEmptyDocument();
        Assertions.assertTrue((boolean)result.isSuccess());
        Assertions.assertEquals((int)0, (int)((Document)result.getObject()).getChildNodes().getLength());
    }

    @Test
    void write() {
        XmlReadWriteUtils.read((File)this.getFileInPackage("example.xml")).consumeOrFail(document -> {
            this.assertExampleXml((Document)document);
            File newFile = new File(this.getFileInPackage("").getAbsoluteFile() + "/new-file-" + Math.random() + ".xml");
            Result result = XmlReadWriteUtils.write((Document)document, (File)newFile);
            Assertions.assertTrue((boolean)result.isSuccess());
            XmlReadWriteUtils.read((File)newFile).consumeOrFail(this::assertExampleXml);
        });
    }

    @Test
    void writeFails() {
        XmlReadWriteUtils.read((File)this.getFileInPackage("example.xml")).consumeOrFail(document -> {
            this.assertExampleXml((Document)document);
            File newFile = new File(this.getFileInPackage("").getAbsoluteFile() + "/new-folder-" + Math.random() + "/new-example.xml");
            Result result = XmlReadWriteUtils.write((Document)document, (File)newFile);
            Assertions.assertTrue((boolean)result.isInternalError());
            Assertions.assertEquals(TransformerException.class, result.getThrowable().getClass());
        });
    }

    @Test
    void writeSafe() {
        XmlReadWriteUtils.read((File)this.getFileInPackage("example.xml")).consumeOrFail(document -> {
            this.assertExampleXml((Document)document);
            File newFile = new File(this.getFileInPackage("").getAbsoluteFile() + "/new-folder-" + Math.random() + "/new-example.xml");
            Result result = XmlReadWriteUtils.writeSafe((Document)document, (File)newFile);
            Assertions.assertTrue((boolean)result.isSuccess());
            XmlReadWriteUtils.read((File)newFile).consumeOrFail(this::assertExampleXml);
        });
    }

    @NotNull
    private File getFileInPackage(String name) {
        URL packagePath = XmlReadWriteUtilsTest.class.getResource(name);
        return new File(packagePath.getFile());
    }

    private void assertExampleXml(Document document) {
        Assertions.assertEquals((int)1, (int)document.getChildNodes().getLength());
    }
}

