/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.data;

import de.kgrupp.inoksjavautils.data.FunctionalMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FunctionalMapTest {
    FunctionalMapTest() {
    }

    @Test
    void putAndGet() {
        FunctionalMap functionalMap = new FunctionalMap((Object)"START-");
        functionalMap.put((Object)1, (Object)"TEST1-", String::concat);
        functionalMap.put((Object)2, (Object)"TEST2", String::concat);
        functionalMap.put((Object)1, (Object)"TEST3", String::concat);
        String result1 = (String)functionalMap.get((Object)1);
        Assertions.assertEquals((Object)"START-TEST1-TEST3", (Object)result1);
        String result2 = (String)functionalMap.get((Object)2);
        Assertions.assertEquals((Object)"START-TEST2", (Object)result2);
        String result3 = (String)functionalMap.get((Object)3);
        Assertions.assertEquals((Object)"START-", (Object)result3);
    }

    @Test
    void stream() {
        FunctionalMap functionalMap = new FunctionalMap((Object)"");
        functionalMap.put((Object)1.0, (Object)"TEST-ONE", String::concat);
        functionalMap.put((Object)2.0, (Object)"TEST-TWO", String::concat);
        Stream stream = functionalMap.stream((key, value) -> "[" + key + ", " + value + "]");
        List list = stream.collect(Collectors.toList());
        Assertions.assertEquals((Object)"[1.0, TEST-ONE]", list.get(0));
        Assertions.assertEquals((Object)"[2.0, TEST-TWO]", list.get(1));
    }

    @Test
    void streamEmpty() {
        FunctionalMap functionalMap = new FunctionalMap((Object)"");
        Stream stream = functionalMap.stream((key, value) -> "TEST");
        Assertions.assertTrue((boolean)stream.collect(Collectors.toList()).isEmpty());
    }
}

