/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.monads.result.Result;
import de.kgrupp.monads.result.ResultUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger log = Logger.getLogger(XmlUtils.class.getName());

    private XmlUtils() {
    }

    public static <T> Result<T> unmarshalFirst(String nodeName, String xmlString, Class<T> clazz) {
        return IOUtils.stringToInputStream(xmlString).flatMap(inputStream -> XmlUtils.unmarshalFirst(nodeName, inputStream, clazz));
    }

    public static <T> Result<T> unmarshalFirst(String nodeName, InputStream xmlInputStream, Class<T> clazz) {
        return XmlUtils.parse(xmlInputStream).flatMap(doc -> {
            Node node = doc.getElementsByTagName(nodeName).item(0);
            if (node == null) {
                return Result.fail((String)("The node '" + nodeName + "' was not found."));
            }
            return XmlUtils.unmarshalFirst(node, clazz);
        });
    }

    private static <T> Result<T> unmarshalFirst(Node node, Class<T> clazz) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement jb = unmarshaller.unmarshal(node, clazz);
            return Result.of((Object)jb.getValue());
        }
        catch (IllegalArgumentException | JAXBException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static Result<Document> parse(InputStream xmlInputStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return Result.of((Object)builder.parse(xmlInputStream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static <T> Result<List<T>> unmarshalEach(String nodeName, String xmlstring, Class<T> clazz) {
        return IOUtils.stringToInputStream(xmlstring).flatMap(inputStream -> XmlUtils.unmarshalEach(nodeName, inputStream, clazz));
    }

    public static <T> Result<List<T>> unmarshalEach(String nodeName, InputStream xmlInputStream, Class<T> clazz) {
        return XmlUtils.parse(xmlInputStream).flatMap(doc -> {
            NodeList nodeList = doc.getElementsByTagName(nodeName);
            Stream<Result> streamResult = StreamSupport.stream(XmlUtils.toIterable(nodeList).spliterator(), false).map(node -> XmlUtils.unmarshalFirst(node, clazz));
            return ResultUtils.flatCombine(streamResult).map(resultStream -> resultStream.collect(Collectors.toList()));
        });
    }

    public static Iterable<Node> toIterable(final NodeList nodeList) {
        return () -> new Iterator<Node>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < nodeList.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("NodeList has no more elements");
                }
                Node nextItem = nodeList.item(this.i);
                ++this.i;
                return nextItem;
            }
        };
    }
}

