/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.monads.result.Result;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class JsonUtils {
    private static final Logger log = Logger.getLogger(JsonUtils.class.getName());

    private JsonUtils() {
    }

    public static Result<String> convertToJsonString(Object object) {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        try {
            return Result.of((Object)mapper.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static <T> Result<T> convertToObject(InputStream jsonInputStream, Class<T> clazz) {
        return IOUtils.inputStreamToString(jsonInputStream).flatMap(jsonString -> JsonUtils.convertToObject(jsonString, clazz));
    }

    public static <T> Result<T> convertToObject(String jsonString, Class<T> clazz) {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        try {
            return Result.of((Object)mapper.readValue(jsonString, clazz));
        }
        catch (IOException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static <T> T convertToObjectUseDefaultOnError(String jsonString, Class<T> clazz, T defaultValue) {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        try {
            return (T)mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            log.warning(String.format("JSON '%s' could not be parsed to object of type '%s'. Default value '%s' will be used.", jsonString, clazz.getSimpleName(), defaultValue));
            return defaultValue;
        }
    }

    public static ObjectMapper getObjectMapper() {
        return new ObjectMapper().registerModules(new Module[]{new JodaModule(), new JSR310Module()});
    }
}

