/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import de.kgrupp.monads.result.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public final class IOUtils {
    private IOUtils() {
    }

    public static Result<String> inputStreamToString(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return Result.of((Object)result.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static Result<InputStream> stringToInputStream(String string) {
        try {
            return Result.of((Object)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8.name())));
        }
        catch (UnsupportedEncodingException e) {
            return Result.fail((Throwable)e);
        }
    }
}

