/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.resbundle;

import de.kgrupp.inoksjavautils.resbundle.KeyProvider;
import java.time.LocalTime;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IJUResourceBundle<T extends KeyProvider> {
    private static final Logger log = Logger.getLogger(IJUResourceBundle.class.getName());
    private final ResourceBundle resourceBundle;

    public IJUResourceBundle(String resourceName) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException e) {
            log.log(Level.SEVERE, "Loading properties failed", e);
            throw e;
        }
    }

    private String get(T constant) {
        return this.resourceBundle.getString(constant.getKey());
    }

    public String getProperty(T constant) {
        return this.get(constant);
    }

    public int getPropertyInt(T constant) {
        String object = this.get(constant);
        return Integer.parseInt(object);
    }

    public long getPropertyLong(T constant) {
        String object = this.get(constant);
        return Long.parseLong(object);
    }

    public boolean getPropertyBoolean(T constant) {
        String object = this.get(constant);
        return Boolean.parseBoolean(object);
    }

    public LocalTime getPropertyLocalTime(T constant) {
        String object = this.get(constant);
        return LocalTime.parse(object);
    }
}

