/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.io;

import de.kgrupp.monads.result.Result;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XmlReadWriteUtils {
    private XmlReadWriteUtils() {
    }

    public static Result<Document> read(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            byte[] data = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return Result.of((Object)builder.parse(stream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static Result<Document> readSafe(File file) {
        if (file.exists()) {
            return XmlReadWriteUtils.read(file);
        }
        return XmlReadWriteUtils.createEmptyDocument();
    }

    public static Result<Document> createEmptyDocument() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return Result.of((Object)docBuilder.newDocument());
        }
        catch (ParserConfigurationException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static Result<Void> write(Document document, File file) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            return Result.emptySuccess();
        }
        catch (TransformerException e) {
            return Result.fail((Throwable)e);
        }
    }

    public static Result<Void> writeSafe(Document document, File file) {
        File parent = new File(file.getParent());
        parent.mkdirs();
        return XmlReadWriteUtils.write(document, file);
    }
}

