/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.io;

public final class OperatingSystemValidator {
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();

    private OperatingSystemValidator() {
    }

    public static boolean isWindows() {
        return OPERATING_SYSTEM.contains("win");
    }

    public static boolean isMac() {
        return OPERATING_SYSTEM.contains("mac");
    }

    public static boolean isUnix() {
        return OPERATING_SYSTEM.contains("nix") || OPERATING_SYSTEM.contains("nux") || OPERATING_SYSTEM.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OPERATING_SYSTEM.contains("sunos");
    }

    public static String getOperatingSystem() {
        if (OperatingSystemValidator.isWindows()) {
            return "win";
        }
        if (OperatingSystemValidator.isMac()) {
            return "osx";
        }
        if (OperatingSystemValidator.isUnix()) {
            return "uni";
        }
        if (OperatingSystemValidator.isSolaris()) {
            return "sol";
        }
        return "err";
    }
}

