/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class FunctionalMap<K, V> {
    private final Map<K, V> map = new HashMap();
    private final V defaultValue;

    public FunctionalMap(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void put(K key, V value, BiFunction<V, V, V> function) {
        V oldValue = this.map.get(key);
        if (oldValue == null) {
            oldValue = this.defaultValue;
        }
        V newValue = function.apply(oldValue, value);
        this.map.put(key, newValue);
    }

    @NotNull
    public V get(K key) {
        V value = this.map.get(key);
        return value != null ? value : this.defaultValue;
    }

    public <B> Stream<B> stream(BiFunction<K, V, B> merger) {
        return this.map.entrySet().stream().map(entry -> merger.apply(entry.getKey(), entry.getValue()));
    }
}

